package com.elitesland.yst.system.service;

import com.elitesland.yst.system.vo.SysPermissionVO;
import com.elitesland.yst.system.vo.SysRolePermissionVO;
import com.elitesland.yst.system.vo.SysRoleVO;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * <pre>
 *     角色权限关联服务
 * </pre>
 * @author Michael Li
 * @date 2020-09-28
 */
public interface SysRolePermissionService {

    Set<SysPermissionVO> listPermissionsByRoleId(Long roleId);

    Set<SysPermissionVO> listMenusByRoleId(Long roleId);

    Set<SysPermissionVO> listActionsByRoleId(Long roleId);

    Map<Long, Set<SysPermissionVO>> listPermissionsByRoleIds(List<Long> roleIds);

    Set<SysRoleVO> listRolesByPermissionId(Long permissionId);

    Map<Long, Set<SysRoleVO>> listRolesByPermissionIds(List<Long> permissionIds);

    Set<SysPermissionVO> listActionsByMenuIdOfRole(Long roleId, Long menuId);

    void saveAll(List<SysRolePermissionVO> rps);

    void saveAllByMenu(Long roleId, Long menuId, Set<Long> permissionIds);

    void removePermissionsByRoleIds(List<Long> roleIds);

    void removeRolesByPermissionIds(List<Long> permissionIds);
}
