package com.elitesland.yst.system.service;

import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.system.param.SysUdcQueryParam;
import com.elitesland.yst.system.vo.SysUdcComboVO;
import com.elitesland.yst.system.vo.SysUdcVO;

import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * <pre>
 * [功能说明]
 * </pre>
 *
 * @author Michael Li
 * @date 2020/6/25
 */
public interface SysUdcService {

    /**
     * 检索分类码
     *
     * @param param 分类查询、分页和排序对象
     * @return 分页结果集
     */
    PagingVO<SysUdcVO> search(SysUdcQueryParam param);

    /**
     * 根据关键字段，返回对应的分类码
     *
     * @param domainCode 领域码
     * @param udcCode    分类码
     * @param udcVal     分类码值
     * @return 分类码对象
     */
    Optional<SysUdcVO> findOne(String domainCode, String udcCode, String udcVal);

    /**
     * 根据关键字段，返回对应的分类码
     *
     * @param domainCode 领域码
     * @param udcCode    分类码
     * @param udcVal     分类码值
     * @return 分类码对象
     */
    SysUdcVO findOneSysUdc(String domainCode, String udcCode, String udcVal);

    /**
     * 根据关键字段，返回对应的分类码
     *
     * @param domain  领域码
     * @param udc     分类码
     * @param valDesc
     * @return 分类码的值和值描述
     */
    List<SysUdcComboVO> listCodeCombosValLike(String domain, String udc, String valDesc);

    /**
     * 根据关键字段，返回对应的分类码
     * 模糊查询itemGroup1 的值和code
     * 蒙华
     *
     * @param domain  领域码
     * @param udcCode
     * @param udc     以udc参数开头的
     * @return 模糊查询
     */
    List<SysUdcComboVO> listSubCodeLike(String domain, String udcCode, String udc);

    /**
     * 根据关键字段，返回对应的分类码
     * 我模糊查询itemGroup1 的值和code
     * 蒙华
     *
     * @param domain 领域码
     * @param
     * @return 模糊查询
     */
    List<SysUdcComboVO> listCodeLike(String domain, String udcCode, String udc);

    /**
     * 根据ID返回对应记录
     *
     * @param id 记录ID
     * @return 记录对象
     */
    Optional<SysUdcVO> findOneById(Long id);

    /**
     * 创建分类码
     *
     * @param code 分类码对象
     */
    void createCode(SysUdcVO code);

    /**
     * 更新分类码
     *
     * @param code 分类码对象
     */
    void updateCode(SysUdcVO code);

    /**
     * 获取用于下来选择的分类码
     *
     * @param domain 领域码
     * @param udc    分类码
     * @return 分类码的值和值描述
     */
    List<SysUdcComboVO> listCodeCombos(String domain, String udc);

    /**
     * 获取分类码的Map对应列表
     *
     * @param domain 领域码
     * @param udc    分类码
     * @return 分类码的值和描述
     */
    Map<String, String> getCodeMap(String domain, String udc);


    /**
     * 获取全部分类码的Map对应列表
     *
     * @return 分类码的值和描述
     */
    Map<String, String> getCodeMapAll();

    /**
     * 组合UDC key 用于map 远程调用查询 udcDesc描述使用.
     * 参数:
     * 1 domainCode 领域code,
     * 2 udcCode udc编码
     * 3 valValue udc值
     * <p>
     * 组合采用&分割
     **/
    static String combinationUdcKey(String domainCode, String udcCode, String valValue) {
        StringBuffer stringBuffer = new StringBuffer();
        String link = "&";
        stringBuffer.append(domainCode).append(link)
                .append(udcCode).append(link)
                .append(valValue);
        return stringBuffer.toString();
    }

    /**
     * 根据关键字段，返回对应的分类码
     * 我模糊查询itemGroup1 的值和code
     * 蒙华
     *
     * @param udc udc值列表
     * @return UDC下拉列表
     */
    List<SysUdcComboVO> findByUdcValues(List<String> udc);

    void removeBySys(String sysCode);

    void removeByMod(String sysCode, String modCode);

    void removeByKey(String sysCode, String modCode, String key);

    void removeByIdInBatch(List<Long> ids);

    List<SysUdcVO> findUdcByIds(List<Long> ids);
}
