package com.elitesland.yst.system.service;

import com.elitesland.yst.system.vo.SysRoleVO;
import com.elitesland.yst.system.vo.SysUserRoleVO;
import com.elitesland.yst.system.vo.SysUserVO;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * <pre>
 *     用户角色关联查询服务
 * </pre>
 *
 * @author Michael Li
 * @date 2020-09-28
 */

public interface SysUserRoleService {

    Set<SysUserVO> listUsersByRoleId(Long roleId);

    Map<Long, Set<SysUserVO>> listUsersByRoleIds(List<Long> roleIds);

    Set<SysRoleVO> listRolesByUserId(Long userId);

    Map<Long, Set<SysRoleVO>> listRolesByUserIds(List<Long> userIds);

    void saveAll(List<SysUserRoleVO> userRoles);

    void removeUsersByRoleIds(List<Long> roleIds);

    void removeRolesByUserIds(List<Long> userIds);
}
