package com.elitesland.yst.system.service;

import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.system.param.*;
import com.elitesland.yst.system.vo.SysPermissionVO;
import com.elitesland.yst.system.vo.SysRoleVO;
import com.elitesland.yst.system.vo.SysUserDTO;
import com.elitesland.yst.system.vo.SysUserVO;

import java.util.List;
import java.util.Set;

/**
 * <pre>
 * 系统用户操作逻辑服务类
 * </pre>
 *
 * @author Michael Li
 * @date 2020/6/16
 */
@Deprecated
public interface SysUserService {

    /**
     * 根据查询条件检索用户信息
     * @param param 查询条件对象
     * @return 用户信息集合
     */
    PagingVO<SysUserVO> search(SysUserQueryParam param);

    /**
     *
     * @param id
     * @return
     */
    SysUserDTO getById(Long id);

    List<SysUserVO> getByIds(List<Long> ids);

    /**
     * 根据用户账号，返回脱敏的用户信息，VO
     *
     * @param username 用户账号
     * @return 脱敏的用户信息
     */
    SysUserDTO getUserByUsername(String username);

    /**
     * 创建新用户
     * @param user 用户账号信息
     * @return 新用户账号ID
     */
    Long create(SysUserNewParam user);
    Long create(SysUserNewParam user,String password);
    void update(SysUserUpdateParam user);

    void changePasswordNoSec(Long userId, String newPassword);

    Boolean switchUserStatus(Long id);

    /**
     * 用户 批量启用/禁用
     * @param param 参数
     */
    void batchSwitchUserStatus(SysUserBatchSwitchParam param);

    Set<SysRoleVO> listRolesByUsername(String username);

    SysUserDTO current();

    List<SysPermissionVO> currentMenu();

    Set<SysPermissionVO> currentActions();

    Set<SysPermissionVO> currentMenuActions(Long menuId);

    void deleteBatch(List<Long> idList);

    void updatePassword(SysPasswordUpdate update);
}
