package com.elitesland.yst.system.vo;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * <pre>
 * [功能说明]
 * </pre>
 *
 * @author Michael Li
 * @date 2020/7/5
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class AntTreeNode implements Comparable<AntTreeNode>, Serializable {

    private static final long serialVersionUID = -3259307725725009616L;

    /**
     * ID
     */
    @ApiModelProperty("key，指ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long key;

    /**
     * 编号
     */
    @ApiModelProperty("编号")
    private String code;

    /**
     * 名称/标题
     */
    @ApiModelProperty("名称/标题")
    private String title;

    /**
     * 深度等级
     */
    @ApiModelProperty("深度等级")
    private Integer level;

    /**
     * 父级Key，指父级ID
     */
    @ApiModelProperty("父级Key，指父级ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long parentKey;

    /**
     * 排序号
     */
    @ApiModelProperty("排序号")
    private Integer sortNo;

    /**
     * 子节点
     */
    @ApiModelProperty("子节点")
    private List<AntTreeNode> children;

//    @Override
//    public int compareTo(AntTreeNode node) {
//        return (this.getSortNo() == null ? 0 : this.getSortNo()) - (node.getSortNo() == null ? 0 : node.getSortNo());
//    }


    @Override
    public int compareTo(AntTreeNode node) {
        return 0;
    }
}
