package com.elitesland.yst.system.vo;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Set;

/**
 * <pre>
 * [功能说明]
 * </pre>
 *
 * @author Michael Li
 * @date 2020/7/19
 */
@Data
@ApiModel("角色查询结果对象")
public class SysRoleVO implements Serializable {

    private static final long serialVersionUID = -795473707562495834L;

    @ApiModelProperty("角色ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long id;

    @ApiModelProperty(value = "角色代码")
    private String code;

    @ApiModelProperty(value = "角色名称")
    private String name;

    @ApiModelProperty("所属租户名称")
    private String tenantName;

    @ApiModelProperty(value = "是否启用")
    Boolean enabled;

    @ApiModelProperty("当前角色下的用户账号集合")
    Set<SysUserVO> users;

    @ApiModelProperty("权限[菜单、能力]ID，在当前角色下的集合，用作Antd Tree的selectedKeys")
    List<Long> permIds;

    @ApiModelProperty("权限集合")
    Set<SysPermissionVO> permissions;

    /**
     * 操作人是否有对应的权限
     */
    @ApiModelProperty("当前操作人是否有权限操作该角色")
    private Boolean noPermission;
}
