package com.elitesland.yst.system.vo;

import com.elitesland.yst.common.base.BaseViewModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 分类码明细表
 * </p>
 *
 * @author Michael Li
 * @date 2020/5/15
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Accessors(chain = true)
@ApiModel(value = "记录分类码的系统表", description = "分类码表")
public class SysUdcVO extends BaseViewModel implements Serializable {

    private static final long serialVersionUID = -6618541083363538072L;

    @ApiModelProperty(value = "领域码")
    @Size(min = 1, max = 20, message = "领域码长度必须在1~20之间")
    String domainCode;

    @ApiModelProperty(value = "UDC码")
    @Size(min = 1, max = 32, message = "UDC码长度必须在1~32之间")
    String udcCode;

    @ApiModelProperty(value = "UDC码名称")
    @Size(min = 1, max = 64, message = "UDC名称长度必须在1~64之间")
    String udcName;

    @ApiModelProperty(value = "UDC值")
    @Size(min = 1, max = 32, message = "UDC名称长度必须在1~32之间")
    String udcVal;

    @ApiModelProperty(value = "值描述")
    @NotBlank(message = "值描述不能为空")
    @Size(min = 1, max = 64, message = "值描述长度必须在1~64之间")
    String valDesc;

    @ApiModelProperty(value = "排序号")
    Integer valSortNo;

    @ApiModelProperty(value = "硬编码")
    Boolean hdFlag;

    @ApiModelProperty(value = "是否开启数据权限")
    Boolean dpFlag;

    @ApiModelProperty(value = "扩展字段1-特殊处理")
    String es1;

    @ApiModelProperty(value = "扩展字段2")
    String es2;

    @ApiModelProperty(value = "扩展字段3")
    String es3;

    @ApiModelProperty(value = "扩展字段4")
    String es4;

    @ApiModelProperty(value = "扩展字段5")
    String es5;

    @ApiModelProperty(value = "扩展字段6")
    String es6;

    @ApiModelProperty(value = "扩展字段7")
    String es7;

    @ApiModelProperty(value = "扩展字段8")
    String es8;

    @ApiModelProperty(value = "扩展浮点1")
    Double ef1;

    @ApiModelProperty(value = "扩展浮点2")
    Double ef2;

    @ApiModelProperty(value = "扩展浮点3")
    Double ef3;

    @ApiModelProperty(value = "扩展浮点4")
    Double ef4;

    @ApiModelProperty(value = "扩展整数1")
    Integer ei1;

    @ApiModelProperty(value = "扩展整数2")
    Integer ei2;

    @ApiModelProperty(value = "扩展整数3")
    Integer ei3;

    @ApiModelProperty(value = "扩展整数4")
    Integer ei4;

    @ApiModelProperty(value = "扩展日期1")
    LocalDateTime ed1;

    @ApiModelProperty(value = "扩展日期2")
    LocalDateTime ed2;

    @ApiModelProperty(value = "扩展日期3")
    LocalDateTime ed3;

    @ApiModelProperty(value = "扩展日期4")
    LocalDateTime ed4;

}
