/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.comm.component.controller;

import com.elitesland.yst.comm.component.service.ComCityCodeComponentService;
import com.elitesland.yst.comm.component.service.ComComponentService;
import com.elitesland.yst.comm.component.service.ComCurrencyComponentService;
import com.elitesland.yst.comm.component.vo.ComCityCodeComponentVO;
import com.elitesland.yst.comm.component.vo.ComCurrencyComponentVO;
import com.elitesland.yst.comm.component.vo.ComPaymentTermSelectVO;
import com.elitesland.yst.comm.component.vo.ComTaxRateSelectVO;
import com.elitesland.yst.common.base.ApiResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/com/component"})
@Api(value="\u516c\u5171\u57df-\u516c\u5171\u7ec4\u4ef6\u63a5\u53e3", tags={"\u516c\u5171\u57df-\u516c\u5171\u7ec4\u4ef6\u63a5\u53e3"})
public class ComComponentController {
    private final ComComponentService comComponentService;
    private final ComCurrencyComponentService comCurrencyComponentService;
    private final ComCityCodeComponentService comCityCodeComponentService;

    @GetMapping(value={"/curr/list"})
    @ApiOperation(value="\u83b7\u53d6\u5168\u90e8\u5e01\u79cd")
    public ApiResult<List<ComCurrencyComponentVO>> currSearch(@RequestParam(required=false) String currCodeOrName) {
        return ApiResult.ok(this.comCurrencyComponentService.currComSearch(currCodeOrName));
    }

    @ApiOperation(value="\u6839\u636e\u7236ID\u83b7\u53d6\u5b50\u533a\u57df\u5217\u8868")
    @GetMapping(value={"/area/pid/{pid}"})
    public ApiResult<List<ComCityCodeComponentVO>> findAreaByPid(@PathVariable Long pid) {
        List<ComCityCodeComponentVO> result = this.comCityCodeComponentService.comFindAreaByPid(pid);
        return ApiResult.ok(result);
    }

    @GetMapping(value={"/tax/list"})
    @ApiOperation(value="\u83b7\u53d6\u5168\u90e8\u7a0e\u7387")
    public ApiResult<List<ComTaxRateSelectVO>> taxRateSelect(@RequestParam(required=false) @ApiParam(value="\u7f16\u53f7/\u63cf\u8ff0\uff0c\u652f\u6301\u6a21\u7cca\u67e5\u8be2") String noName) {
        return ApiResult.ok(this.comComponentService.selectTaxRate(noName));
    }

    @GetMapping(value={"/paymentTerm/list"})
    @ApiOperation(value="\u83b7\u53d6\u5168\u90e8\u652f\u4ed8\u6761\u6b3e")
    public ApiResult<List<ComPaymentTermSelectVO>> paymentTermSelect(@RequestParam(required=false) @ApiParam(value="\u7f16\u53f7/\u540d\u79f0\uff0c\u652f\u6301\u6a21\u7cca\u67e5\u8be2") String codeName) {
        return ApiResult.ok(this.comComponentService.selectPaymentTerm(codeName));
    }

    public ComComponentController(ComComponentService comComponentService, ComCurrencyComponentService comCurrencyComponentService, ComCityCodeComponentService comCityCodeComponentService) {
        this.comComponentService = comComponentService;
        this.comCurrencyComponentService = comCurrencyComponentService;
        this.comCityCodeComponentService = comCityCodeComponentService;
    }
}

