/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.comm.component.repo;

import com.elitesland.yst.comm.component.vo.ComPaymentTermSelectVO;
import com.elitesland.yst.comm.component.vo.ComTaxRateSelectVO;
import com.elitesland.yst.comm.entity.QComPaymentTermDO;
import com.elitesland.yst.comm.entity.QComTaxRateDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ComComponentRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QComTaxRateDO comTaxRateDO = QComTaxRateDO.comTaxRateDO;
    private final QComPaymentTermDO comPaymentTermDO = QComPaymentTermDO.comPaymentTermDO;

    public List<ComTaxRateSelectVO> selectTaxRate(String noDesc) {
        JPAQuery query = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ComTaxRateSelectVO.class, (Expression[])new Expression[]{this.comTaxRateDO.id, this.comTaxRateDO.taxRateNo, this.comTaxRateDO.taxRateDesc, this.comTaxRateDO.taxRateValue, this.comTaxRateDO.taxRateIndex})).from((EntityPath)this.comTaxRateDO);
        if (StringUtils.isNotBlank((CharSequence)noDesc)) {
            String likeStr = "%" + noDesc + "%";
            query.where((Predicate)this.comTaxRateDO.taxRateNo.like(likeStr).or((Predicate)this.comTaxRateDO.taxRateDesc.like(likeStr)));
        }
        query.where((Predicate)this.comTaxRateDO.deleteFlag.isNull().or((Predicate)this.comTaxRateDO.deleteFlag.eq((Object)0)));
        return query.fetch();
    }

    public List<ComPaymentTermSelectVO> selectPaymentTerm(String codeName) {
        JPAQuery query = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ComPaymentTermSelectVO.class, (Expression[])new Expression[]{this.comPaymentTermDO.id, this.comPaymentTermDO.ptCode, this.comPaymentTermDO.ptName, this.comPaymentTermDO.days, this.comPaymentTermDO.baseDayType, this.comPaymentTermDO.dayCalcMethod})).from((EntityPath)this.comPaymentTermDO);
        if (StringUtils.isNotBlank((CharSequence)codeName)) {
            String likeStr = "%" + codeName + "%";
            query.where((Predicate)this.comPaymentTermDO.ptCode.like(likeStr).or((Predicate)this.comPaymentTermDO.ptName.like(likeStr)));
        }
        query.where((Predicate)this.comPaymentTermDO.deleteFlag.isNull().or((Predicate)this.comPaymentTermDO.deleteFlag.eq((Object)0)));
        return query.fetch();
    }

    public ComComponentRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

