/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.comm.component.service.impl;

import com.elitesland.yst.comm.component.repo.ComCityCodeComponentRepoProc;
import com.elitesland.yst.comm.component.service.ComCityCodeComponentService;
import com.elitesland.yst.comm.component.vo.ComCityCodeComponentVO;
import com.elitesland.yst.comm.repo.ComCityCodeRepo;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class ComCityCodeComponentServiceImpl
implements ComCityCodeComponentService {
    private final ComCityCodeRepo comCityCodeRepo;
    private final ComCityCodeComponentRepoProc comCityCodeComponentRepoProc;
    private static final String CACHE_NAME = "COM_CITY_CODE";

    @Override
    @Cacheable(cacheNames={"COM_CITY_CODE"}, key="'SUB_LIST_' + #p0", condition="#p0 == null", unless="#result == null")
    public List<ComCityCodeComponentVO> comFindAreaByPid(Long pid) {
        if (pid == null) {
            return null;
        }
        List<ComCityCodeComponentVO> result = this.comCityCodeComponentRepoProc.searchByPid(pid);
        if (CollectionUtils.isEmpty(result)) {
            return null;
        }
        result.forEach(r -> r.setIsLeaf(!this.comCityCodeRepo.existsByPid(r.getPid())));
        return result;
    }

    private static List<ComCityCodeComponentVO> build(List<ComCityCodeComponentVO> areas, Map<Long, List<ComCityCodeComponentVO>> pidAreasMap) {
        for (ComCityCodeComponentVO area : areas) {
            if (pidAreasMap.containsKey(area.getId())) {
                List<ComCityCodeComponentVO> subAreas = ComCityCodeComponentServiceImpl.build(pidAreasMap.get(area.getId()), pidAreasMap);
                area.setIsLeaf(false);
                area.setAreas(subAreas);
                continue;
            }
            area.setIsLeaf(true);
        }
        return areas;
    }

    public ComCityCodeComponentServiceImpl(ComCityCodeRepo comCityCodeRepo, ComCityCodeComponentRepoProc comCityCodeComponentRepoProc) {
        this.comCityCodeRepo = comCityCodeRepo;
        this.comCityCodeComponentRepoProc = comCityCodeComponentRepoProc;
    }
}

