/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.comm.repo;

import com.elitesland.yst.comm.consumer.dto.ComTaxRateRpcDTO;
import com.elitesland.yst.comm.consumer.param.ComTaxRateRpcDtoParam;
import com.elitesland.yst.comm.entity.QComTaxRateDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class ComTaxRateRpcRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QComTaxRateDO comTaxRateDO = QComTaxRateDO.comTaxRateDO;

    public List<ComTaxRateRpcDTO> findRpcDtoByParam(ComTaxRateRpcDtoParam param) {
        List taxRates;
        List taxRateNos;
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (CollectionUtils.isNotEmpty((Collection)param.getTaxRateNos()) && CollectionUtils.isNotEmpty(taxRateNos = param.getTaxRateNos().stream().filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
            predicates.add(this.comTaxRateDO.taxRateNo.in(taxRateNos));
        }
        if (CollectionUtils.isNotEmpty((Collection)param.getTaxRates()) && CollectionUtils.isNotEmpty(taxRates = param.getTaxRates().stream().filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
            predicates.add(this.comTaxRateDO.taxRateValue.in(taxRates));
        }
        if (CollectionUtils.isEmpty(predicates)) {
            return Collections.emptyList();
        }
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ComTaxRateRpcDTO.class, (Expression[])new Expression[]{this.comTaxRateDO.id, this.comTaxRateDO.taxRateNo, this.comTaxRateDO.taxRateDesc, this.comTaxRateDO.taxRateValue, this.comTaxRateDO.taxRateIndex, this.comTaxRateDO.validFrom, this.comTaxRateDO.validTo})).from((EntityPath)this.comTaxRateDO)).where(ExpressionUtils.allOf(predicates))).fetch();
    }

    public ComTaxRateRpcRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

