/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.comm.rest;

import com.elitesland.yst.comm.vo.param.ComPaymentTermQueryParamVO;
import com.elitesland.yst.comm.vo.save.ComPaymentTermSaveVO;
import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.system.service.ComPaymentTermService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/com/comPaymentTerm"})
@Api(value="\u652f\u4ed8\u6761\u6b3e", tags={"\u652f\u4ed8\u6761\u6b3e"})
public class ComPaymentTermController {
    private final ComPaymentTermService comPaymentTermService;

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u5217\u51fa\u6240\u6709\u7684\u4ed8\u6b3e\u6761\u6b3e")
    public ApiResult<?> list() {
        return ApiResult.ok((Object)this.comPaymentTermService.list());
    }

    @PostMapping(value={"/createOne"})
    @ApiOperation(value="\u4fdd\u5b58\u652f\u4ed8\u6761\u6b3e")
    public ApiResult<?> createOne(@RequestBody ComPaymentTermSaveVO param) {
        Long id = this.comPaymentTermService.createOne(param);
        return ApiResult.ok((Object)id);
    }

    @PostMapping(value={"/createBatch"})
    @ApiOperation(value="\u6279\u91cf\u4fdd\u5b58\u652f\u4ed8\u6761\u6b3e")
    public ApiResult<?> createBatch(@RequestBody List<ComPaymentTermSaveVO> param) {
        List idList = this.comPaymentTermService.createBatch(param);
        return ApiResult.ok((Object)idList);
    }

    @PutMapping(value={"/update/{paymentTermId}"})
    @ApiOperation(value="\u66f4\u65b0\u652f\u4ed8\u6761\u6b3e")
    public ApiResult<?> update(@PathVariable Long paymentTermId, @RequestBody ComPaymentTermSaveVO param) {
        param.setId(paymentTermId);
        this.comPaymentTermService.update(param);
        return ApiResult.ok();
    }

    @PostMapping(value={"/findIdBatch"})
    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u652f\u4ed8\u6761\u6b3e")
    public ApiResult<?> findIdBatch(@RequestBody List<String> paymentTermIdList) {
        List list = paymentTermIdList.stream().map(Long::valueOf).collect(Collectors.toList());
        List result = this.comPaymentTermService.findIdBatch(list);
        return ApiResult.ok((Object)result);
    }

    @PostMapping(value={"/findIdOne/{paymentTermId}"})
    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u652f\u4ed8\u6761\u6b3e")
    public ApiResult<?> findIdOne(@PathVariable String paymentTermId) {
        Optional result = this.comPaymentTermService.findIdOne(Long.valueOf(paymentTermId));
        return ApiResult.ok((Object)result);
    }

    @PostMapping(value={"/findCodeOne/{paymentTermCode}"})
    @ApiOperation(value="\u6839\u636eCode\u67e5\u8be2\u652f\u4ed8\u6761\u6b3e")
    public ApiResult<?> findCodeOne(@PathVariable String paymentTermCode) {
        Optional result = this.comPaymentTermService.findCodeOne(paymentTermCode);
        return ApiResult.ok((Object)result);
    }

    @PostMapping(value={"/search"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u652f\u4ed8\u6761\u6b3e")
    public ApiResult<?> search(@RequestBody ComPaymentTermQueryParamVO param) {
        PagingVO result = this.comPaymentTermService.search(param);
        return ApiResult.ok((Object)result);
    }

    @DeleteMapping(value={"/deleteOne"})
    @ApiOperation(value="\u5220\u9664\u652f\u4ed8\u6761\u6b3e")
    public ApiResult<?> deleteOne(Long paymentTermId) {
        this.comPaymentTermService.deleteOne(paymentTermId);
        return ApiResult.ok();
    }

    @DeleteMapping(value={"/deleteBatch"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u652f\u4ed8\u6761\u6b3e")
    public ApiResult<?> deleteBatch(@RequestBody List<String> paymentTermIdList) {
        List idList = paymentTermIdList.stream().map(Long::valueOf).collect(Collectors.toList());
        this.comPaymentTermService.deleteBatch(idList);
        return ApiResult.ok();
    }

    @PostMapping(value={"/updateDeleteFlag"})
    @ApiOperation(value="\u66f4\u65b0\u652f\u4ed8\u6761\u6b3e\u5220\u9664\u6807\u8bc6")
    public ApiResult<?> updateDeleteFlag(String id) {
        this.comPaymentTermService.updateDeleteFlag(Long.valueOf(id));
        return ApiResult.ok();
    }

    public ComPaymentTermController(ComPaymentTermService comPaymentTermService) {
        this.comPaymentTermService = comPaymentTermService;
    }
}

