/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.comm.service;

import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.yst.comm.repo.ComCityCodeRepo;
import com.elitesland.yst.comm.repo.ComCityCodeRepoProc;
import com.elitesland.yst.comm.service.ComCityCodeProviderService;
import com.elitesland.yst.comm.vo.ComCityCodeVO;
import com.elitesland.yst.common.util.RedisUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.util.CollectionUtils;

@DubboService(version="${provider.service.version}")
@UnicomTag(value="GENERAL")
public class ComCityCodeProviderServiceImpl
implements ComCityCodeProviderService {
    private final ComCityCodeRepo comCityCodeRepo;
    private final ComCityCodeRepoProc comCityCodeRepoProc;
    private static final String CACHE_NAME = "COM_CITY_CODE";
    private final RedisUtils redisUtils;

    public List<ComCityCodeVO> findAllCityCodes() {
        List<ComCityCodeVO> allAreas = this.comCityCodeRepoProc.searchAll();
        if (CollectionUtils.isEmpty(allAreas)) {
            return null;
        }
        Map<Long, List<ComCityCodeVO>> pidAreasMap = allAreas.stream().collect(Collectors.groupingBy(ComCityCodeVO::getPid));
        List pAreas = pidAreasMap.getOrDefault(0L, null);
        if (CollectionUtils.isEmpty((Collection)pAreas)) {
            return null;
        }
        return ComCityCodeProviderServiceImpl.build(pAreas, pidAreasMap);
    }

    @Cacheable(cacheNames={"COM_CITY_CODE"}, key="'SUB_LIST_' + #p0", condition="#p0 == null", unless="#result == null")
    public List<ComCityCodeVO> findByPid(Long pid) {
        if (pid == null) {
            return null;
        }
        List<ComCityCodeVO> result = this.comCityCodeRepoProc.searchByPid(pid);
        if (CollectionUtils.isEmpty(result)) {
            return null;
        }
        result.forEach(r -> r.setIsLeaf(Boolean.valueOf(!this.comCityCodeRepo.existsByPid(r.getPid()))));
        return result;
    }

    private static List<ComCityCodeVO> build(List<ComCityCodeVO> areas, Map<Long, List<ComCityCodeVO>> pidAreasMap) {
        for (ComCityCodeVO area : areas) {
            if (pidAreasMap.containsKey(area.getId())) {
                List<ComCityCodeVO> subAreas = ComCityCodeProviderServiceImpl.build(pidAreasMap.get(area.getId()), pidAreasMap);
                area.setIsLeaf(Boolean.valueOf(false));
                area.setAreas(subAreas);
                continue;
            }
            area.setIsLeaf(Boolean.valueOf(true));
        }
        return areas;
    }

    public List<ComCityCodeVO> findAllCityCodesTillCounty() {
        List<ComCityCodeVO> cityCodes = null;
        String key = "COM_CITY_CODE_findAllCityCodesTillCounty";
        Object redisResult = this.redisUtils.get(key);
        if (redisResult != null) {
            return (List)redisResult;
        }
        List<ComCityCodeVO> allAreas = this.comCityCodeRepoProc.searchAllFilterAreaCode();
        if (CollectionUtils.isEmpty(allAreas)) {
            return Collections.emptyList();
        }
        Map<Long, List<ComCityCodeVO>> pidAreasMap = allAreas.stream().collect(Collectors.groupingBy(ComCityCodeVO::getPid));
        List pAreas = pidAreasMap.getOrDefault(0L, null);
        cityCodes = ComCityCodeProviderServiceImpl.build(pAreas, pidAreasMap);
        this.redisUtils.set(key, cityCodes);
        return cityCodes;
    }

    public ComCityCodeProviderServiceImpl(ComCityCodeRepo comCityCodeRepo, ComCityCodeRepoProc comCityCodeRepoProc, RedisUtils redisUtils) {
        this.comCityCodeRepo = comCityCodeRepo;
        this.comCityCodeRepoProc = comCityCodeRepoProc;
        this.redisUtils = redisUtils;
    }
}

