/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.comm.service;

import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.yst.comm.entity.QComCurrDO;
import com.elitesland.yst.comm.repo.ComCurrRepo;
import com.elitesland.yst.comm.repo.ComCurrRepoProc;
import com.elitesland.yst.comm.service.ComCurrProviderService;
import com.elitesland.yst.comm.vo.ComCurrVO;
import com.elitesland.yst.comm.vo.param.ComCurrQueryParamVO;
import com.elitesland.yst.comm.vo.resp.ComCurrRespVO;
import com.elitesland.yst.common.base.PagingVO;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.cache.annotation.Cacheable;

@DubboService(version="${provider.service.version}")
@UnicomTag(value="GENERAL")
public class ComCurrProviderServiceImpl
implements ComCurrProviderService {
    private final ComCurrRepo comCurrRepo;
    private final ComCurrRepoProc comCurrRepoProc;
    private static final String CURR_CACHE = "COM_CURRENCY";

    @Cacheable(cacheNames={"COM_CURRENCY"}, key="'ALL'", unless="#result == null")
    public List<ComCurrVO> findAllVos() {
        return this.comCurrRepoProc.findAllVo();
    }

    public PagingVO<ComCurrRespVO> search(ComCurrQueryParamVO param) {
        JPAQuery comcurrVOJPAQuery = (JPAQuery)this.comCurrRepoProc.select().where(this.comCurrRepoProc.where(param));
        param.fillOrders(comcurrVOJPAQuery, (EntityPathBase)QComCurrDO.comCurrDO);
        param.setPaging(comcurrVOJPAQuery);
        List fetch = comcurrVOJPAQuery.fetch();
        return PagingVO.builder().total(Long.valueOf(comcurrVOJPAQuery.fetchCount())).records(fetch).build();
    }

    public ComCurrRespVO getCodeOne(String Code) {
        JPAQuery<ComCurrRespVO> comcurrVOJPAQuery = this.comCurrRepoProc.select();
        QComCurrDO comCurrDO = QComCurrDO.comCurrDO;
        comcurrVOJPAQuery.where((Predicate)comCurrDO.currCode.eq((Object)Code));
        ComCurrRespVO comcurrVO = (ComCurrRespVO)comcurrVOJPAQuery.fetchOne();
        return comcurrVO;
    }

    public ComCurrRespVO getIdOne(Long Id) {
        JPAQuery<ComCurrRespVO> comcurrVOJPAQuery = this.comCurrRepoProc.select();
        QComCurrDO comCurrDO = QComCurrDO.comCurrDO;
        comcurrVOJPAQuery.where((Predicate)comCurrDO.id.eq((Object)Id));
        ComCurrRespVO comcurrVO = (ComCurrRespVO)comcurrVOJPAQuery.fetchOne();
        return comcurrVO;
    }

    public List<ComCurrRespVO> findIdBatch(List<Long> idList) {
        List<ComCurrRespVO> comCurrVOS = this.comCurrRepo.findAllById(idList).stream().map(comCurrDO -> {
            ComCurrRespVO comcurrVO = new ComCurrRespVO();
            BeanUtils.copyProperties((Object)comCurrDO, (Object)comcurrVO);
            return comcurrVO;
        }).collect(Collectors.toList());
        return comCurrVOS;
    }

    public List<ComCurrRespVO> findByCodes(List<String> currList) {
        if (currList == null || currList.size() == 0) {
            return new ArrayList<ComCurrRespVO>();
        }
        return ((JPAQuery)this.comCurrRepoProc.select().where(this.comCurrRepoProc.where(currList))).fetch();
    }

    public List<ComCurrRespVO> searchAll() {
        return ((JPAQuery)this.comCurrRepoProc.select().where(this.comCurrRepoProc.where())).fetch();
    }

    public ComCurrProviderServiceImpl(ComCurrRepo comCurrRepo, ComCurrRepoProc comCurrRepoProc) {
        this.comCurrRepo = comCurrRepo;
        this.comCurrRepoProc = comCurrRepoProc;
    }
}

