/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.comm.service;

import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.yst.comm.convert.ComCurrRateConvert;
import com.elitesland.yst.comm.entity.ComCurrRateDO;
import com.elitesland.yst.comm.entity.QComCurrRateDO;
import com.elitesland.yst.comm.repo.ComCurrRateRepo;
import com.elitesland.yst.comm.repo.ComCurrRateRepoProc;
import com.elitesland.yst.comm.service.ComCurrRateService;
import com.elitesland.yst.comm.vo.ComCurrRateVO;
import com.elitesland.yst.comm.vo.param.ComCurrRateQueryParamVO;
import com.elitesland.yst.common.base.BaseModel;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.system.service.ComCurrService;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@DubboService
@UnicomTag(value="GENERAL")
public class ComCurrRateServiceImpl
implements ComCurrRateService {
    private final ComCurrRateRepo comCurrRateRepo;
    private final ComCurrRateRepoProc currRateRepoProc;
    private final ComCurrService comCurrService;
    private final EntityManager entityManager;

    public PagingVO<ComCurrRateVO> search(ComCurrRateQueryParamVO param) {
        JPAQuery currRates = (JPAQuery)this.currRateRepoProc.select().where(this.currRateRepoProc.where(param));
        param.fillOrders(currRates, (EntityPathBase)QComCurrRateDO.comCurrRateDO);
        param.setPaging(currRates);
        List records = currRates.fetch();
        this.setCurrName(records);
        return PagingVO.builder().total(Long.valueOf(currRates.fetchCount())).records(records).build();
    }

    public Double findRatio(ComCurrRateQueryParamVO param) {
        String fromCurr = param.getFromCurr();
        String toCurr = param.getToCurr();
        if (StrUtil.isBlank((CharSequence)fromCurr) || fromCurr.equals(toCurr)) {
            return 1.0;
        }
        List comCurrRateVOS = ((JPAQuery)this.currRateRepoProc.select().where(this.currRateRepoProc.where(param))).fetch();
        if (!CollectionUtils.isEmpty((Collection)comCurrRateVOS)) {
            ComCurrRateVO comCurrRateVO = comCurrRateVOS.stream().filter(o -> o.getValidFrom() != null && o.getRatio() != null).max(Comparator.comparing(ComCurrRateVO::getValidFrom)).orElse(null);
            if (comCurrRateVO == null) {
                comCurrRateVO = comCurrRateVOS.stream().filter(o -> o.getRatio() != null).findAny().orElse(null);
            }
            if (comCurrRateVO != null) {
                return comCurrRateVO.getRatio().doubleValue();
            }
        } else {
            String midCurr = param.getFromCurr();
            param.setFromCurr(param.getToCurr());
            param.setToCurr(midCurr);
            comCurrRateVOS = ((JPAQuery)this.currRateRepoProc.select().where(this.currRateRepoProc.where(param))).fetch();
            if (!CollectionUtils.isEmpty((Collection)comCurrRateVOS)) {
                ComCurrRateVO comCurrRateVO = comCurrRateVOS.stream().filter(o -> o.getValidFrom() != null && o.getRatio() != null).max(Comparator.comparing(ComCurrRateVO::getValidFrom)).orElse(null);
                if (comCurrRateVO == null) {
                    comCurrRateVO = comCurrRateVOS.stream().filter(o -> o.getRatio() != null).findAny().orElse(null);
                }
                if (comCurrRateVO != null) {
                    BigDecimal v = BigDecimal.ONE.divide(BigDecimal.valueOf(comCurrRateVO.getRatio().floatValue()).setScale(7, RoundingMode.HALF_UP), 7, RoundingMode.HALF_UP);
                    return v.doubleValue();
                }
            }
        }
        return null;
    }

    public Optional<ComCurrRateVO> findIdOne(Long currRateId) {
        ComCurrRateVO currRate = (ComCurrRateVO)((JPAQuery)this.currRateRepoProc.select().where(this.currRateRepoProc.where(currRateId))).fetchFirst();
        if (currRate != null) {
            ArrayList<ComCurrRateVO> records = new ArrayList<ComCurrRateVO>();
            records.add(currRate);
            this.setCurrName(records);
        }
        return Optional.ofNullable(currRate);
    }

    public List<ComCurrRateVO> findIdBatch(List<Long> idList) {
        List<ComCurrRateVO> comCurrRateVOS = this.comCurrRateRepo.findAllById(idList).stream().map(ComCurrRateVO2 -> {
            ComCurrRateVO comCurrRateVO = new ComCurrRateVO();
            BeanUtils.copyProperties((Object)ComCurrRateVO2, (Object)comCurrRateVO);
            return comCurrRateVO;
        }).collect(Collectors.toList());
        this.setCurrName(comCurrRateVOS);
        return comCurrRateVOS;
    }

    @Transactional
    public Long createOne(ComCurrRateVO currRate) {
        ComCurrRateDO comCurrRateDO = ComCurrRateConvert.INSTANCE.saveVOToDO(currRate);
        this.comCurrRateRepo.save(comCurrRateDO);
        return currRate.getId();
    }

    @Transactional
    public List<Long> createBatch(List<ComCurrRateVO> voList) {
        List comCurrRateDOS = voList.stream().map(ComCurrRateConvert.INSTANCE::saveVOToDO).collect(Collectors.toList());
        List currRateDOS = this.comCurrRateRepo.saveAll(comCurrRateDOS);
        return currRateDOS.stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    @Transactional
    public void update(ComCurrRateVO currRate) {
        ComCurrRateDO comCurrRateDO = ComCurrRateConvert.INSTANCE.saveVOToDO(currRate);
        this.comCurrRateRepo.save(comCurrRateDO);
    }

    @Transactional
    public void deleteOne(Long id) {
        if (this.comCurrRateRepo.existsById(id)) {
            this.comCurrRateRepo.deleteById(id);
        }
    }

    @Transactional
    public void deleteBatch(List<Long> itemIdList) {
        ArrayList delList = new ArrayList();
        itemIdList.stream().forEach(i -> delList.add(new ComCurrRateDO((Long)i){
            final /* synthetic */ Long val$i;
            {
                this.val$i = l;
                this.setId(this.val$i);
            }
        }));
        this.comCurrRateRepo.deleteInBatch(delList);
    }

    @Transactional
    public void updateDeleteFlag(Long id) {
        ComCurrRateVO currRate = (ComCurrRateVO)((JPAQuery)this.currRateRepoProc.select().where(this.currRateRepoProc.where(id))).fetchFirst();
        if (currRate != null) {
            ComCurrRateDO comCurrRateDO = new ComCurrRateDO();
            BeanUtils.copyProperties((Object)currRate, (Object)comCurrRateDO);
            comCurrRateDO.setDeleteFlag(1);
            this.comCurrRateRepo.save(comCurrRateDO);
        }
    }

    private void setCurrName(List<ComCurrRateVO> records) {
        if (!CollectionUtils.isEmpty(records)) {
            List allCurr;
            List fromCurrList = records.stream().filter(i -> StringUtils.hasText((String)i.getFromCurr())).map(ComCurrRateVO::getFromCurr).distinct().collect(Collectors.toList());
            List toCurrList = records.stream().filter(i -> StringUtils.hasText((String)i.getToCurr())).map(ComCurrRateVO::getToCurr).distinct().collect(Collectors.toList());
            ArrayList currList = new ArrayList();
            currList.addAll(fromCurrList);
            currList.addAll(toCurrList);
            if (!CollectionUtils.isEmpty(currList) && !CollectionUtils.isEmpty((Collection)(allCurr = this.comCurrService.findByCodes(currList)))) {
                records.stream().forEach(i -> {
                    allCurr.stream().filter(curr -> curr.getCurrCode().equals(i.getFromCurr())).findAny().ifPresent(b -> i.setFromCurrName(b.getCurrName()));
                    allCurr.stream().filter(curr -> curr.getCurrCode().equals(i.getToCurr())).findAny().ifPresent(b -> i.setToCurrName(b.getCurrName()));
                });
            }
        }
    }

    public ComCurrRateServiceImpl(ComCurrRateRepo comCurrRateRepo, ComCurrRateRepoProc currRateRepoProc, ComCurrService comCurrService, EntityManager entityManager) {
        this.comCurrRateRepo = comCurrRateRepo;
        this.currRateRepoProc = currRateRepoProc;
        this.comCurrService = comCurrService;
        this.entityManager = entityManager;
    }
}

