/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.comm.service;

import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.yst.comm.convert.ComCurrConvert;
import com.elitesland.yst.comm.entity.ComCurrDO;
import com.elitesland.yst.comm.entity.QComCurrDO;
import com.elitesland.yst.comm.repo.ComCurrRepo;
import com.elitesland.yst.comm.repo.ComCurrRepoProc;
import com.elitesland.yst.comm.vo.ComCurrVO;
import com.elitesland.yst.comm.vo.param.ComCurrQueryParamVO;
import com.elitesland.yst.comm.vo.resp.ComCurrRespVO;
import com.elitesland.yst.comm.vo.save.ComCurrSaveVO;
import com.elitesland.yst.common.base.BaseModel;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.system.service.ComCurrService;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@UnicomTag(value="GENERAL")
public class ComCurrServiceImpl
implements ComCurrService {
    private final ComCurrRepo comCurrRepo;
    private final ComCurrRepoProc comCurrRepoProc;
    private static final String CURR_CACHE = "COM_CURRENCY";

    @Cacheable(cacheNames={"COM_CURRENCY"}, key="'ALL'", unless="#result == null")
    public List<ComCurrVO> findAllVos() {
        return this.comCurrRepoProc.findAllVo();
    }

    public PagingVO<ComCurrRespVO> search(ComCurrQueryParamVO param) {
        JPAQuery comcurrVOJPAQuery = (JPAQuery)this.comCurrRepoProc.select().where(this.comCurrRepoProc.where(param));
        param.fillOrders(comcurrVOJPAQuery, (EntityPathBase)QComCurrDO.comCurrDO);
        param.setPaging(comcurrVOJPAQuery);
        List fetch = comcurrVOJPAQuery.fetch();
        return PagingVO.builder().total(Long.valueOf(comcurrVOJPAQuery.fetchCount())).records(fetch).build();
    }

    public ComCurrRespVO getCodeOne(String Code) {
        return this.findCodeOne(Code).orElse(null);
    }

    public ComCurrRespVO getIdOne(Long Id) {
        return this.findIdOne(Id).orElse(null);
    }

    public Optional<ComCurrRespVO> findCodeOne(String Code) {
        JPAQuery<ComCurrRespVO> comcurrVOJPAQuery = this.comCurrRepoProc.select();
        QComCurrDO comCurrDO = QComCurrDO.comCurrDO;
        comcurrVOJPAQuery.where((Predicate)comCurrDO.currCode.eq((Object)Code));
        ComCurrRespVO comcurrVO = (ComCurrRespVO)comcurrVOJPAQuery.fetchOne();
        return Optional.ofNullable(comcurrVO);
    }

    public Optional<ComCurrRespVO> findIdOne(Long Id) {
        JPAQuery<ComCurrRespVO> comcurrVOJPAQuery = this.comCurrRepoProc.select();
        QComCurrDO comCurrDO = QComCurrDO.comCurrDO;
        comcurrVOJPAQuery.where((Predicate)comCurrDO.id.eq((Object)Id));
        ComCurrRespVO comcurrVO = (ComCurrRespVO)comcurrVOJPAQuery.fetchOne();
        return Optional.ofNullable(comcurrVO);
    }

    public List<ComCurrRespVO> findIdBatch(List<Long> idList) {
        List<ComCurrRespVO> comCurrVOS = this.comCurrRepo.findAllById(idList).stream().map(comCurrDO -> {
            ComCurrRespVO comcurrVO = new ComCurrRespVO();
            BeanUtils.copyProperties((Object)comCurrDO, (Object)comcurrVO);
            return comcurrVO;
        }).collect(Collectors.toList());
        return comCurrVOS;
    }

    @Transactional
    public Long createOne(ComCurrSaveVO comCurrSaveVO) throws BusinessException {
        comCurrSaveVO.setId(null);
        return ((ComCurrDO)this.comCurrRepo.save(ComCurrConvert.INSTANCE.saveVOToDO(comCurrSaveVO))).getId();
    }

    @Transactional
    public List<Long> createBatch(List<ComCurrSaveVO> saveVOS) {
        List<ComCurrDO> saveDOs = saveVOS.stream().map(ComCurrConvert.INSTANCE::saveVOToDO).collect(Collectors.toList());
        saveDOs.forEach(d -> d.setId(null));
        return this.comCurrRepo.saveAll(saveDOs).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(ComCurrSaveVO comCurrSaveVO) throws BusinessException {
        if (!this.comCurrRepo.existsById(comCurrSaveVO.getId())) {
            throw new BusinessException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        this.comCurrRepo.save(ComCurrConvert.INSTANCE.saveVOToDO(comCurrSaveVO));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteOne(Long id) throws BusinessException {
        if (!this.comCurrRepo.existsById(id)) {
            throw new BusinessException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        this.comCurrRepo.deleteById(id);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<Long> idList) {
        idList.forEach(id -> this.comCurrRepo.deleteById(id));
        ArrayList delList = new ArrayList();
        idList.stream().forEach(i -> delList.add(new ComCurrDO((Long)i){
            final /* synthetic */ Long val$i;
            {
                this.val$i = l;
                this.setId(this.val$i);
            }
        }));
        this.comCurrRepo.deleteInBatch(delList);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateDeleteFlag(Long id) {
        QComCurrDO comCurrDO = QComCurrDO.comCurrDO;
        BooleanExpression predicate = comCurrDO.isNotNull();
        Optional item = this.comCurrRepo.findOne((Predicate)(predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)comCurrDO.id.eq((Object)id))));
        if (!item.isPresent()) {
            throw new BusinessException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        ComCurrDO comCurrDO1 = (ComCurrDO)item.get();
        comCurrDO1.setDeleteFlag(1);
        this.comCurrRepo.save(comCurrDO1);
    }

    public List<ComCurrRespVO> findByCodes(List<String> currList) {
        if (currList == null || currList.size() == 0) {
            return new ArrayList<ComCurrRespVO>();
        }
        return ((JPAQuery)this.comCurrRepoProc.select().where(this.comCurrRepoProc.where(currList))).fetch();
    }

    public List<ComCurrRespVO> searchAll() {
        return ((JPAQuery)this.comCurrRepoProc.select().where(this.comCurrRepoProc.where())).fetch();
    }

    public ComCurrServiceImpl(ComCurrRepo comCurrRepo, ComCurrRepoProc comCurrRepoProc) {
        this.comCurrRepo = comCurrRepo;
        this.comCurrRepoProc = comCurrRepoProc;
    }
}

