/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.comm.service;

import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.yst.comm.convert.ComDistrictConvert;
import com.elitesland.yst.comm.repo.ComDistrictRepo;
import com.elitesland.yst.comm.repo.ComDistrictRepoProc;
import com.elitesland.yst.comm.service.ComDistrictProviderService;
import com.elitesland.yst.comm.vo.param.ComDistrictQueryParamVO;
import com.elitesland.yst.comm.vo.resp.ComDistrictComboVO;
import com.elitesland.yst.comm.vo.resp.ComDistrictRespVO;
import com.elitesland.yst.common.base.PagingVO;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

@DubboService(version="${provider.service.version}")
@UnicomTag(value="GENERAL")
public class ComDistrictProviderServiceImpl
implements ComDistrictProviderService {
    private final ComDistrictRepo districtRepo;
    private final ComDistrictRepoProc districtRepoProc;

    public PagingVO<ComDistrictRespVO> search(ComDistrictQueryParamVO param) {
        Page ret = this.districtRepo.findAll(this.districtRepoProc.where(param), (Pageable)param.getPageRequest());
        List districts = ret.getContent().stream().map(ComDistrictConvert.INSTANCE::doToVO).collect(Collectors.toList());
        return PagingVO.builder().total(Long.valueOf(ret.getTotalElements())).records(districts).build();
    }

    public List<ComDistrictRespVO> listByPId(Long pId) {
        return this.districtRepo.findAllByParentId(pId).stream().map(ComDistrictConvert.INSTANCE::doToVO).collect(Collectors.toList());
    }

    public List<ComDistrictComboVO> listByPCode(String pCode) {
        String pCodeParam = StringUtils.isBlank((CharSequence)pCode) ? "" : pCode;
        return this.districtRepo.findAllByParentCode(pCodeParam).stream().map(ComDistrictConvert.INSTANCE::doToComboVO).collect(Collectors.toList());
    }

    public List<ComDistrictComboVO> listByPCode2(String pCode) {
        String pCodeParam = StringUtils.isBlank((CharSequence)pCode) ? "" : pCode;
        return this.districtRepo.findAllByParentCode(pCodeParam).stream().map(ComDistrictConvert.INSTANCE::doToComboVO2).collect(Collectors.toList());
    }

    public List<ComDistrictComboVO> listByDistLevelNum(Integer distLevelNum) {
        return this.districtRepo.findAllByDistLevelNum(distLevelNum).stream().map(ComDistrictConvert.INSTANCE::doToComboVO).collect(Collectors.toList());
    }

    public ComDistrictRespVO getById(Long id) {
        return this.districtRepo.findById(id).map(ComDistrictConvert.INSTANCE::doToVO).orElse(null);
    }

    public List<ComDistrictComboVO> getByDistCodes(List<String> distCodes) {
        return this.districtRepo.findByDistCode(distCodes).stream().map(ComDistrictConvert.INSTANCE::doToComboVO).collect(Collectors.toList());
    }

    public List<ComDistrictComboVO> getCityByDistCodes(List<String> distCodes, String distLevelNum) {
        return this.districtRepo.findByDistCode(distCodes, distLevelNum).stream().map(ComDistrictConvert.INSTANCE::doToComboVO).collect(Collectors.toList());
    }

    public ComDistrictProviderServiceImpl(ComDistrictRepo districtRepo, ComDistrictRepoProc districtRepoProc) {
        this.districtRepo = districtRepo;
        this.districtRepoProc = districtRepoProc;
    }
}

