/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.comm.service;

import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.yst.comm.convert.ComPaymentTermConvert;
import com.elitesland.yst.comm.entity.QComPaymentTermDO;
import com.elitesland.yst.comm.repo.ComPaymentTermRepo;
import com.elitesland.yst.comm.repo.ComPaymentTermRepoProc;
import com.elitesland.yst.comm.service.ComPaymentTermProviderService;
import com.elitesland.yst.comm.vo.param.ComPaymentTermQueryParamVO;
import com.elitesland.yst.comm.vo.resp.ComPaymentTermRespVO;
import com.elitesland.yst.common.base.PagingVO;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

@DubboService(version="${provider.service.version}")
@UnicomTag(value="GENERAL")
public class ComPaymentTermProviderServiceImpl
implements ComPaymentTermProviderService {
    private static final Logger log = LoggerFactory.getLogger(ComPaymentTermProviderServiceImpl.class);
    private final ComPaymentTermRepo comPaymentTermRepo;
    private final ComPaymentTermRepoProc comPaymentTermRepoProc;

    public PagingVO<ComPaymentTermRespVO> search(ComPaymentTermQueryParamVO queryParam) {
        JPAQuery comPaymentTermVOJPAQuery = (JPAQuery)this.comPaymentTermRepoProc.select().where(this.comPaymentTermRepoProc.where(queryParam));
        queryParam.fillOrders(comPaymentTermVOJPAQuery, (EntityPathBase)QComPaymentTermDO.comPaymentTermDO);
        queryParam.setPaging(comPaymentTermVOJPAQuery);
        List records = comPaymentTermVOJPAQuery.fetch();
        return PagingVO.builder().total(Long.valueOf(comPaymentTermVOJPAQuery.fetchCount())).records(records).build();
    }

    public ComPaymentTermRespVO getCodeOne(String Code) {
        QComPaymentTermDO paymentTerm = QComPaymentTermDO.comPaymentTermDO;
        JPAQuery<ComPaymentTermRespVO> jpaQuery = this.comPaymentTermRepoProc.select();
        jpaQuery.where((Predicate)paymentTerm.ptCode.eq((Object)Code));
        return (ComPaymentTermRespVO)jpaQuery.fetchOne();
    }

    public ComPaymentTermRespVO getIdOne(Long Id) {
        QComPaymentTermDO paymentTerm = QComPaymentTermDO.comPaymentTermDO;
        JPAQuery<ComPaymentTermRespVO> jpaQuery = this.comPaymentTermRepoProc.select();
        jpaQuery.where((Predicate)paymentTerm.id.eq((Object)Id));
        return (ComPaymentTermRespVO)jpaQuery.fetchOne();
    }

    public List<ComPaymentTermRespVO> findCodeBatch(List<String> paymentTermCodes) {
        if (paymentTermCodes == null || paymentTermCodes.size() == 0) {
            return new ArrayList<ComPaymentTermRespVO>();
        }
        QComPaymentTermDO paymentTerm = QComPaymentTermDO.comPaymentTermDO;
        JPAQuery<ComPaymentTermRespVO> jpaQuery = this.comPaymentTermRepoProc.select();
        jpaQuery.where((Predicate)paymentTerm.ptCode.in(paymentTermCodes));
        return jpaQuery.fetch();
    }

    public List<ComPaymentTermRespVO> findIdBatch(List<Long> idList) {
        return this.comPaymentTermRepo.findAllById(idList).stream().map(paymentTermDO -> {
            ComPaymentTermRespVO comPaymentTermVO = new ComPaymentTermRespVO();
            BeanUtils.copyProperties((Object)paymentTermDO, (Object)comPaymentTermVO);
            return comPaymentTermVO;
        }).collect(Collectors.toList());
    }

    public List<ComPaymentTermRespVO> list() {
        return this.comPaymentTermRepo.findAll().stream().map(ComPaymentTermConvert.INSTANCE::doToVO).collect(Collectors.toList());
    }

    public ComPaymentTermProviderServiceImpl(ComPaymentTermRepo comPaymentTermRepo, ComPaymentTermRepoProc comPaymentTermRepoProc) {
        this.comPaymentTermRepo = comPaymentTermRepo;
        this.comPaymentTermRepoProc = comPaymentTermRepoProc;
    }
}

