/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.comm.service;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.yst.comm.entity.ComTaxRateDO;
import com.elitesland.yst.comm.entity.QComTaxRateDO;
import com.elitesland.yst.comm.repo.ComTaxRateRepo;
import com.elitesland.yst.comm.repo.ComTaxRateRepoProc;
import com.elitesland.yst.comm.service.ComTaxRateProviderService;
import com.elitesland.yst.comm.vo.param.ComCommonTaxRateQueryParamVO;
import com.elitesland.yst.comm.vo.param.ComTaxRateQueryParamDTO;
import com.elitesland.yst.comm.vo.param.ComTaxRateQueryParamVO;
import com.elitesland.yst.comm.vo.resp.ComCommonTaxRateRespVO;
import com.elitesland.yst.comm.vo.resp.ComTaxRateRespVO;
import com.elitesland.yst.comm.vo.resp.ComTaxRateVO;
import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.core.udc.UdcService;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@DubboService(version="${provider.service.version}")
@UnicomTag(value="GENERAL")
public class ComTaxRateProviderServiceImpl
implements ComTaxRateProviderService {
    private final ComTaxRateRepo comTaxRateRepo;
    private final ComTaxRateRepoProc comTaxRateRepoProc;
    private final UdcService udcService;

    @SysCodeProc
    public PagingVO<ComTaxRateRespVO> search(ComTaxRateQueryParamVO comTaxRateQueryParam) {
        JPAQuery records = (JPAQuery)this.comTaxRateRepoProc.select().where(this.comTaxRateRepoProc.where(comTaxRateQueryParam));
        comTaxRateQueryParam.fillOrders(records, (EntityPathBase)QComTaxRateDO.comTaxRateDO);
        comTaxRateQueryParam.setPaging(records);
        return PagingVO.builder().total(Long.valueOf(records.fetchCount())).records(records.fetch()).build();
    }

    @SysCodeProc
    public ComTaxRateRespVO getCodeOne(String code) {
        if (StrUtil.isBlank((CharSequence)code)) {
            return null;
        }
        QComTaxRateDO jpaQdo = QComTaxRateDO.comTaxRateDO;
        return (ComTaxRateRespVO)((JPAQuery)this.comTaxRateRepoProc.select().where((Predicate)jpaQdo.taxRateNo.eq((Object)code))).fetchOne();
    }

    @SysCodeProc
    public ComTaxRateRespVO getIdOne(Long Id) {
        JPAQuery comTaxRateVOJPAQuery = (JPAQuery)this.comTaxRateRepoProc.select().where(this.comTaxRateRepoProc.where(Id));
        return (ComTaxRateRespVO)comTaxRateVOJPAQuery.fetchOne();
    }

    @SysCodeProc
    public List<ComTaxRateRespVO> findIdBatch(List<Long> idList) {
        QComTaxRateDO jpaQDo = QComTaxRateDO.comTaxRateDO;
        JPAQuery where = (JPAQuery)this.comTaxRateRepoProc.select().where((Predicate)jpaQDo.id.in(idList));
        return where.fetch();
    }

    public List<ComTaxRateRespVO> query(ComTaxRateQueryParamDTO queryParamDTO) {
        List<ComTaxRateRespVO> respVOS = this.comTaxRateRepoProc.query(queryParamDTO);
        if (respVOS.isEmpty()) {
            return respVOS;
        }
        this.renderUdc(respVOS);
        return respVOS;
    }

    public List<ComTaxRateVO> findBytaxRateNoList(List<String> strings) {
        List<ComTaxRateDO> comTaxRateDOS = this.comTaxRateRepo.findByTaxRateNoIn(strings);
        return comTaxRateDOS.stream().map(comTaxRateDO -> {
            ComTaxRateVO comTaxRateVO = new ComTaxRateVO();
            BeanUtil.copyProperties((Object)comTaxRateDO, (Object)comTaxRateVO, (String[])new String[0]);
            return comTaxRateVO;
        }).collect(Collectors.toList());
    }

    public ComCommonTaxRateRespVO getRatioOrNull(ComCommonTaxRateQueryParamVO param) {
        List VOS;
        ComCommonTaxRateRespVO res = new ComCommonTaxRateRespVO();
        if (param == null || StringUtils.isEmpty((Object)param.getVTxa1())) {
            res.setACn(Integer.valueOf(0));
            res.setAItm(null);
            res.setTRate(Double.valueOf(0.0));
            return res;
        }
        if (!"V".equals(param.getVExr1()) || "N".equals(param.getVItm())) {
            res.setACn(Integer.valueOf(0));
            res.setAItm(null);
            res.setTRate(Double.valueOf(0.0));
            return res;
        }
        if ("Y".equals(param.getVItm())) {
            param.setAItm("Y");
        } else {
            if (StringUtils.isEmpty((Object)param.getVItm())) {
                res.setACn(Integer.valueOf(0));
                res.setAItm(null);
                res.setTRate(Double.valueOf(0.0));
                return res;
            }
            param.setAItm(param.getVItm());
        }
        if (param.getVDj() == null) {
            param.setVDj(LocalDateTime.now());
        }
        if ((VOS = ((JPAQuery)this.comTaxRateRepoProc.select().where(this.comTaxRateRepoProc.where(param))).fetch()).size() > 0) {
            if (VOS.size() == 1) {
                res.setACn(Integer.valueOf(1));
                res.setAItm(param.getAItm());
                res.setTRate(((ComTaxRateRespVO)VOS.get(0)).getTaxRateValue());
            } else {
                param.setAItm("Y");
                ComTaxRateRespVO VO = (ComTaxRateRespVO)((JPAQuery)this.comTaxRateRepoProc.select().where(this.comTaxRateRepoProc.where(param))).fetchOne();
                if (VO != null) {
                    res.setACn(Integer.valueOf(VOS.size()));
                    res.setAItm(param.getAItm());
                    res.setTRate(VO.getTaxRateValue());
                } else {
                    res.setACn(Integer.valueOf(VOS.size()));
                    res.setAItm(param.getAItm());
                    res.setTRate(Double.valueOf(0.0));
                }
            }
        } else {
            res.setACn(Integer.valueOf(0));
            res.setAItm(param.getAItm());
            res.setTRate(Double.valueOf(0.0));
        }
        return res;
    }

    public ComTaxRateVO findByTaxRateNoAndIndexOrNull(String taxRateNo, String taxRateIndex) {
        ComTaxRateDO byTaxRateNoAndTaxRateIndex = this.comTaxRateRepo.findByTaxRateNoAndTaxRateIndex(taxRateNo, taxRateIndex);
        return byTaxRateNoAndTaxRateIndex == null ? null : (ComTaxRateVO)BeanUtil.copyProperties((Object)byTaxRateNoAndTaxRateIndex, ComTaxRateVO.class, (String[])new String[0]);
    }

    public List<ComTaxRateRespVO> findBytaxRateNoInAndIndexIn(Set<String> taxRateNo, Set<String> taxRateIndex) {
        return this.comTaxRateRepo.findByTaxRateNoInAndTaxRateIndexIn(taxRateNo, taxRateIndex).stream().map(comTaxRateDO -> {
            ComTaxRateRespVO comTaxRateVO = new ComTaxRateRespVO();
            BeanUtil.copyProperties((Object)comTaxRateDO, (Object)comTaxRateVO, (String[])new String[0]);
            return comTaxRateVO;
        }).collect(Collectors.toList());
    }

    public PagingVO<ComTaxRateRespVO> searchAll(ComTaxRateQueryParamVO param) {
        JPAQuery records = (JPAQuery)this.comTaxRateRepoProc.select().where(this.comTaxRateRepoProc.where(param));
        return PagingVO.builder().total(Long.valueOf(records.fetchCount())).records(records.fetch()).build();
    }

    private void renderUdc(List<ComTaxRateRespVO> respVOS) {
        if (CollectionUtils.isEmpty(respVOS)) {
            return;
        }
        Map udcMap = this.udcService.getCodeMap("COM", "TAX_RATE_INDEX");
        if (udcMap.isEmpty()) {
            return;
        }
        for (ComTaxRateRespVO respVO : respVOS) {
            if (!StringUtils.hasText((String)respVO.getTaxRateIndex())) continue;
            respVO.setTaxRateIndexName((String)udcMap.get(respVO.getTaxRateIndex()));
        }
    }

    public ComTaxRateProviderServiceImpl(ComTaxRateRepo comTaxRateRepo, ComTaxRateRepoProc comTaxRateRepoProc, UdcService udcService) {
        this.comTaxRateRepo = comTaxRateRepo;
        this.comTaxRateRepoProc = comTaxRateRepoProc;
        this.udcService = udcService;
    }
}

