/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.comm.service;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.yst.comm.convert.ComTaxRateConvert;
import com.elitesland.yst.comm.entity.ComTaxRateDO;
import com.elitesland.yst.comm.entity.QComTaxRateDO;
import com.elitesland.yst.comm.repo.ComTaxRateRepo;
import com.elitesland.yst.comm.repo.ComTaxRateRepoProc;
import com.elitesland.yst.comm.vo.param.ComCommonTaxRateQueryParamVO;
import com.elitesland.yst.comm.vo.param.ComTaxRateQueryParamDTO;
import com.elitesland.yst.comm.vo.param.ComTaxRateQueryParamVO;
import com.elitesland.yst.comm.vo.resp.ComCommonTaxRateRespVO;
import com.elitesland.yst.comm.vo.resp.ComTaxRateRespVO;
import com.elitesland.yst.comm.vo.resp.ComTaxRateVO;
import com.elitesland.yst.comm.vo.save.ComTaxRateSaveVO;
import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.core.udc.UdcService;
import com.elitesland.yst.system.service.ComTaxRateService;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@UnicomTag(value="GENERAL")
public class ComTaxRateServiceImpl
implements ComTaxRateService {
    private final ComTaxRateRepo comTaxRateRepo;
    private final ComTaxRateRepoProc comTaxRateRepoProc;
    private final UdcService udcService;

    @SysCodeProc
    public PagingVO<ComTaxRateRespVO> search(ComTaxRateQueryParamVO comTaxRateQueryParam) {
        JPAQuery records = (JPAQuery)this.comTaxRateRepoProc.select().where(this.comTaxRateRepoProc.where(comTaxRateQueryParam));
        comTaxRateQueryParam.fillOrders(records, (EntityPathBase)QComTaxRateDO.comTaxRateDO);
        comTaxRateQueryParam.setPaging(records);
        return PagingVO.builder().total(Long.valueOf(records.fetchCount())).records(records.fetch()).build();
    }

    public ComTaxRateRespVO getCodeOne(String Code) {
        return this.findCodeOne(Code).orElse(null);
    }

    public ComTaxRateRespVO getIdOne(Long Id) {
        return this.findIdOne(Id).orElse(null);
    }

    @SysCodeProc
    public Optional<ComTaxRateRespVO> findCodeOne(String Code) {
        return Optional.empty();
    }

    @SysCodeProc
    public Optional<ComTaxRateRespVO> findIdOne(Long Id) {
        JPAQuery comTaxRateVOJPAQuery = (JPAQuery)this.comTaxRateRepoProc.select().where(this.comTaxRateRepoProc.where(Id));
        return Optional.ofNullable((ComTaxRateRespVO)comTaxRateVOJPAQuery.fetchOne());
    }

    @SysCodeProc
    public List<ComTaxRateRespVO> findIdBatch(List<Long> idList) {
        QComTaxRateDO jpaQDo = QComTaxRateDO.comTaxRateDO;
        JPAQuery where = (JPAQuery)this.comTaxRateRepoProc.select().where((Predicate)jpaQDo.id.in(idList));
        return where.fetch();
    }

    @Transactional(rollbackOn={Exception.class})
    public Long createOne(ComTaxRateSaveVO comTaxRateSaveVO) {
        if (comTaxRateSaveVO.getDeleteFlag() == null) {
            comTaxRateSaveVO.setDeleteFlag(Integer.valueOf(0));
        }
        if (comTaxRateSaveVO.getValidTo().isBefore(comTaxRateSaveVO.getValidFrom())) {
            throw new BusinessException("\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u5728\u751f\u6548\u65e5\u671f\u4e4b\u524d");
        }
        ComTaxRateQueryParamVO comTaxRateQueryParam = new ComTaxRateQueryParamVO();
        comTaxRateQueryParam.setTaxRateIndex(comTaxRateSaveVO.getTaxRateIndex());
        comTaxRateQueryParam.setTaxRateNo(comTaxRateSaveVO.getTaxRateNo());
        List taxRateVoList = ((JPAQuery)this.comTaxRateRepoProc.select().where(this.comTaxRateRepoProc.checkWhere(comTaxRateQueryParam))).fetch();
        ArrayList<ComTaxRateDO> action = new ArrayList<ComTaxRateDO>();
        if (taxRateVoList.size() > 0) {
            for (ComTaxRateRespVO oldTaxRate : taxRateVoList) {
                ComTaxRateDO comTaxRateDO;
                if (oldTaxRate.getValidTo().isBefore(comTaxRateSaveVO.getValidFrom()) || oldTaxRate.getValidFrom().isAfter(comTaxRateSaveVO.getValidTo())) continue;
                if (oldTaxRate.getValidFrom().isBefore(comTaxRateSaveVO.getValidFrom())) {
                    if (oldTaxRate.getValidTo().isBefore(comTaxRateSaveVO.getValidTo()) || oldTaxRate.getValidTo().isEqual(comTaxRateSaveVO.getValidTo())) {
                        comTaxRateDO = new ComTaxRateDO();
                        BeanUtils.copyProperties((Object)oldTaxRate, (Object)comTaxRateDO);
                        comTaxRateDO.setValidTo(LocalDateTime.of(LocalDate.from(oldTaxRate.getValidFrom().minusDays(1L)), LocalTime.of(23, 59, 59)));
                        action.add(comTaxRateDO);
                        continue;
                    }
                    if (oldTaxRate.getValidTo().isAfter(comTaxRateSaveVO.getValidTo())) {
                        ComTaxRateDO beforeOldSal = new ComTaxRateDO();
                        ComTaxRateDO afterOldSal = new ComTaxRateDO();
                        ComTaxRateDO comTaxRateDO2 = new ComTaxRateDO();
                        BeanUtils.copyProperties((Object)oldTaxRate, (Object)comTaxRateDO2);
                        BeanUtils.copyProperties((Object)oldTaxRate, (Object)beforeOldSal);
                        BeanUtils.copyProperties((Object)oldTaxRate, (Object)afterOldSal);
                        beforeOldSal.setValidTo(LocalDateTime.of(LocalDate.from(comTaxRateSaveVO.getValidFrom().minusDays(1L)), LocalTime.of(23, 59, 59)));
                        afterOldSal.setValidFrom(LocalDateTime.of(LocalDate.from(comTaxRateSaveVO.getValidTo().plusDays(1L)), LocalTime.MIN));
                        oldTaxRate.setDeleteFlag(Integer.valueOf(1));
                        beforeOldSal.setId(null);
                        afterOldSal.setId(null);
                        comTaxRateDO2.setDeleteFlag(1);
                        action.add(comTaxRateDO2);
                        action.add(beforeOldSal);
                        action.add(afterOldSal);
                        continue;
                    }
                }
                if (!oldTaxRate.getValidFrom().isAfter(comTaxRateSaveVO.getValidFrom()) && !oldTaxRate.getValidFrom().isEqual(comTaxRateSaveVO.getValidFrom())) continue;
                if (oldTaxRate.getValidTo().isBefore(comTaxRateSaveVO.getValidTo()) || oldTaxRate.getValidTo().isEqual(comTaxRateSaveVO.getValidTo())) {
                    comTaxRateDO = new ComTaxRateDO();
                    BeanUtils.copyProperties((Object)oldTaxRate, (Object)comTaxRateDO);
                    comTaxRateDO.setDeleteFlag(1);
                    action.add(comTaxRateDO);
                }
                if (!oldTaxRate.getValidTo().isAfter(comTaxRateSaveVO.getValidTo())) continue;
                comTaxRateDO = new ComTaxRateDO();
                BeanUtils.copyProperties((Object)oldTaxRate, (Object)comTaxRateDO);
                comTaxRateDO.setValidFrom(LocalDateTime.of(LocalDate.from(comTaxRateSaveVO.getValidTo().plusDays(1L)), LocalTime.MIN));
                action.add(comTaxRateDO);
            }
        }
        if (action.size() > 0) {
            this.comTaxRateRepo.saveAll(action);
        }
        return ((ComTaxRateDO)this.comTaxRateRepo.save(ComTaxRateConvert.INSTANCE.saveVOToDO(comTaxRateSaveVO))).getId();
    }

    public List<Long> createBatch(List<ComTaxRateSaveVO> List2) {
        return null;
    }

    @Transactional(rollbackOn={Exception.class})
    public void update(ComTaxRateSaveVO objDo) {
        Optional optional = this.comTaxRateRepo.findById(objDo.getId());
        if (!optional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + objDo.getId());
        }
        BeanUtil.copyProperties((Object)objDo, optional.get(), (CopyOptions)CopyOptions.create().setIgnoreNullValue(true).setIgnoreError(true));
        this.comTaxRateRepo.save((ComTaxRateDO)optional.get());
    }

    @Transactional
    public void deleteOne(Long Id) {
    }

    @Transactional
    public void deleteBatch(List<Long> idList) {
        idList.forEach(arg_0 -> ((ComTaxRateRepo)this.comTaxRateRepo).deleteById(arg_0));
    }

    public void updateDeleteFlag(Long id) {
    }

    public List<ComTaxRateVO> findBytaxRateNoList(List<String> strings) {
        List<ComTaxRateDO> comTaxRateDOS = this.comTaxRateRepo.findByTaxRateNoIn(strings);
        return comTaxRateDOS.stream().map(comTaxRateDO -> {
            ComTaxRateVO comTaxRateVO = new ComTaxRateVO();
            BeanUtil.copyProperties((Object)comTaxRateDO, (Object)comTaxRateVO, (String[])new String[0]);
            return comTaxRateVO;
        }).collect(Collectors.toList());
    }

    public ComCommonTaxRateRespVO getRatioOrNull(ComCommonTaxRateQueryParamVO param) {
        return this.getRatio(param).orElse(null);
    }

    public ComTaxRateVO findByTaxRateNoAndIndexOrNull(String taxRateNo, String taxRateIndex) {
        return this.findBytaxRateNoAndIndex(taxRateNo, taxRateIndex).orElse(null);
    }

    public Optional<ComCommonTaxRateRespVO> getRatio(ComCommonTaxRateQueryParamVO param) {
        List VOS;
        ComCommonTaxRateRespVO res = new ComCommonTaxRateRespVO();
        if (param == null || StringUtils.isEmpty((Object)param.getVTxa1())) {
            res.setACn(Integer.valueOf(0));
            res.setAItm(null);
            res.setTRate(Double.valueOf(0.0));
            return Optional.of(res);
        }
        if (!"V".equals(param.getVExr1()) || "N".equals(param.getVItm())) {
            res.setACn(Integer.valueOf(0));
            res.setAItm(null);
            res.setTRate(Double.valueOf(0.0));
            return Optional.of(res);
        }
        if ("Y".equals(param.getVItm())) {
            param.setAItm("Y");
        } else {
            if (StringUtils.isEmpty((Object)param.getVItm())) {
                res.setACn(Integer.valueOf(0));
                res.setAItm(null);
                res.setTRate(Double.valueOf(0.0));
                return Optional.of(res);
            }
            param.setAItm(param.getVItm());
        }
        if (param.getVDj() == null) {
            param.setVDj(LocalDateTime.now());
        }
        if ((VOS = ((JPAQuery)this.comTaxRateRepoProc.select().where(this.comTaxRateRepoProc.where(param))).fetch()).size() > 0) {
            if (VOS.size() == 1) {
                res.setACn(Integer.valueOf(1));
                res.setAItm(param.getAItm());
                res.setTRate(((ComTaxRateRespVO)VOS.get(0)).getTaxRateValue());
            } else {
                param.setAItm("Y");
                ComTaxRateRespVO VO = (ComTaxRateRespVO)((JPAQuery)this.comTaxRateRepoProc.select().where(this.comTaxRateRepoProc.where(param))).fetchOne();
                if (VO != null) {
                    res.setACn(Integer.valueOf(VOS.size()));
                    res.setAItm(param.getAItm());
                    res.setTRate(VO.getTaxRateValue());
                } else {
                    res.setACn(Integer.valueOf(VOS.size()));
                    res.setAItm(param.getAItm());
                    res.setTRate(Double.valueOf(0.0));
                }
            }
        } else {
            res.setACn(Integer.valueOf(0));
            res.setAItm(param.getAItm());
            res.setTRate(Double.valueOf(0.0));
        }
        return Optional.ofNullable(res);
    }

    public Optional<ComTaxRateVO> findBytaxRateNoAndIndex(String taxRateNo, String taxRateIndex) {
        ComTaxRateDO byTaxRateNoAndTaxRateIndex = this.comTaxRateRepo.findByTaxRateNoAndTaxRateIndex(taxRateNo, taxRateIndex);
        return byTaxRateNoAndTaxRateIndex == null ? Optional.empty() : Optional.of((ComTaxRateVO)BeanUtil.copyProperties((Object)byTaxRateNoAndTaxRateIndex, ComTaxRateVO.class, (String[])new String[0]));
    }

    public List<ComTaxRateRespVO> findBytaxRateNoInAndIndexIn(Set<String> taxRateNo, Set<String> taxRateIndex) {
        return this.comTaxRateRepo.findByTaxRateNoInAndTaxRateIndexIn(taxRateNo, taxRateIndex).stream().map(comTaxRateDO -> {
            ComTaxRateRespVO comTaxRateVO = new ComTaxRateRespVO();
            BeanUtil.copyProperties((Object)comTaxRateDO, (Object)comTaxRateVO, (String[])new String[0]);
            return comTaxRateVO;
        }).collect(Collectors.toList());
    }

    public PagingVO<ComTaxRateRespVO> searchAll(ComTaxRateQueryParamVO param) {
        JPAQuery records = (JPAQuery)this.comTaxRateRepoProc.select().where(this.comTaxRateRepoProc.where(param));
        return PagingVO.builder().total(Long.valueOf(records.fetchCount())).records(records.fetch()).build();
    }

    public List<ComTaxRateRespVO> query(ComTaxRateQueryParamDTO queryParamDTO) {
        List<ComTaxRateRespVO> respVOS = this.comTaxRateRepoProc.query(queryParamDTO);
        if (respVOS.isEmpty()) {
            return respVOS;
        }
        this.renderUdc(respVOS);
        return respVOS;
    }

    private void renderUdc(List<ComTaxRateRespVO> respVOS) {
        if (CollectionUtils.isEmpty(respVOS)) {
            return;
        }
        Map udcMap = this.udcService.getCodeMap("COM", "TAX_RATE_INDEX");
        if (udcMap.isEmpty()) {
            return;
        }
        for (ComTaxRateRespVO respVO : respVOS) {
            if (!StringUtils.hasText((String)respVO.getTaxRateIndex())) continue;
            respVO.setTaxRateIndexName((String)udcMap.get(respVO.getTaxRateIndex()));
        }
    }

    public ComTaxRateServiceImpl(ComTaxRateRepo comTaxRateRepo, ComTaxRateRepoProc comTaxRateRepoProc, UdcService udcService) {
        this.comTaxRateRepo = comTaxRateRepo;
        this.comTaxRateRepoProc = comTaxRateRepoProc;
        this.udcService = udcService;
    }
}

