/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.event.listener;

import com.elitesland.cloudt.authorization.core.SecurityContextUtil;
import com.elitesland.yst.event.OnlineUserInfoChangeEvent;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import com.elitesland.yst.system.service.ISysUserService;
import com.elitesland.yst.system.vo.SysUserDTO;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class OnlineUserInfoChangeListener
implements ApplicationListener<OnlineUserInfoChangeEvent> {
    private static final Logger log = LoggerFactory.getLogger(OnlineUserInfoChangeListener.class);
    @Autowired
    private ISysUserService sysUserService;

    public void onApplicationEvent(@NonNull OnlineUserInfoChangeEvent event) {
        GeneralUserDetails currentUser = SecurityContextUtil.currentUser();
        CompletableFuture.runAsync(() -> this.execute(currentUser, event.getSysUserId()));
    }

    private void execute(GeneralUserDetails currentUser, Long sysUserId) {
        if (currentUser == null || sysUserId == null) {
            log.warn("\u66f4\u65b0\u5728\u7ebf\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u4fe1\u606f");
            return;
        }
        if (!currentUser.getUser().getId().equals(sysUserId)) {
            log.warn("\u66f4\u65b0\u5728\u7ebf\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u66f4\u65b0\u7528\u6237\u975e\u5f53\u524d\u7528\u6237");
            return;
        }
        SysUserDTO userInfo = this.sysUserService.getById(currentUser.getUser().getId());
        currentUser.setUser(userInfo);
        SecurityContextUtil.updateCurrentUser((GeneralUserDetails)currentUser);
    }
}

