/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.rest;

import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.system.param.SysUserIdFlowRoleRpcParam;
import com.elitesland.yst.system.provider.SysRoleRpcService;
import com.elitesland.yst.system.provider.SysUserRpcService;
import com.elitesland.yst.system.provider.dto.SysRoleRpcDTO;
import com.elitesland.yst.system.provider.dto.SysUserRpcDTO;
import com.elitesland.yst.system.provider.param.SysRoleRpcDtoParam;
import com.elitesland.yst.system.provider.param.SysUserRpcDtoParam;
import com.elitesland.yst.system.provider.param.SysUserRpcSaveParam;
import com.elitesland.yst.system.service.ISysUserService;
import com.elitesland.yst.system.service.SysUserFlowRoleRpcService;
import com.elitesland.yst.system.service.SysUserService;
import com.elitesland.yst.system.vo.SysUserDTO;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/dubbo/test"})
@Api(value="Dubbo\u63a5\u53e3\u6d4b\u8bd5", tags={"Dubbo\u63a5\u53e3\u6d4b\u8bd5"})
public class DubboTestController {
    private static final Logger log = LoggerFactory.getLogger(DubboTestController.class);
    @DubboReference
    private SysUserFlowRoleRpcService sysUserFlowRoleRpcService;
    @DubboReference
    private SysUserRpcService sysUserRpcService;
    @DubboReference
    private SysRoleRpcService sysRoleRpcService;
    @Autowired
    private ISysUserService iSysUserService;
    @Autowired
    private ObjectMapper objectMapper;
    @DubboReference(version="${provider.service.version}", check=false)
    private SysUserService sysUserService;

    @PostMapping(value={"/user/flowRoles"})
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u89d2\u8272\u67e5\u7528\u6237ID")
    public List<Long> findUserIdsByFlowRoles(@RequestBody SysUserIdFlowRoleRpcParam param) {
        return this.sysUserFlowRoleRpcService.findUserIdsByFlowRoles(param);
    }

    @PostMapping(value={"/user/rpc/dto"})
    @ApiOperation(value="\u7528\u6237DTO\u67e5\u8be2")
    public List<SysUserRpcDTO> findUserRpcDtoTest(@RequestBody SysUserRpcDtoParam param) {
        return this.sysUserRpcService.findUserRpcDtoByParam(param);
    }

    @PostMapping(value={"/role/rpc/dto"})
    @ApiOperation(value="\u5e94\u7528\u89d2\u8272DTO\u67e5\u8be2")
    public List<SysRoleRpcDTO> findRoleRpcDtoTest(@RequestBody SysRoleRpcDtoParam param) {
        return this.sysRoleRpcService.findRoleRpcDtoByParam(param);
    }

    @PostMapping(value={"/user/rpc/save"})
    @ApiOperation(value="\u7528\u6237\u65b0\u589e")
    public ApiResult<Object> userRpcSaveParam(@RequestBody SysUserRpcSaveParam param) {
        return ApiResult.ok((Object)this.sysUserRpcService.sysUserAccountCreate(param));
    }

    @RequestMapping(value={"/log/getUserByUsername"}, method={RequestMethod.GET})
    public String sayHello() {
        log.info("USER", (Object)"\u7528\u6237\u6d88\u606f{}", (Object)"user info");
        SysUserDTO sysUserDTO = this.sysUserService.getUserByUsername("admin");
        log.info("DEVICE", (Object)"\u8bbe\u5907\u6d88\u606f{}", (Object)sysUserDTO);
        return "Hello World!";
    }

    @ApiOperation(value="\u7528\u6237\u83b7\u53d6")
    @GetMapping(value={"/user/get"})
    public String getUserInfo(String username) throws Exception {
        SysUserDTO obj = this.iSysUserService.getUserByUsername(username);
        return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)obj);
    }
}

