/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.export;

import cn.hutool.core.collection.CollUtil;
import com.el.coordinator.boot.fsm.service.exportdata.DataExport;
import com.el.coordinator.core.common.jpa.vo.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.supportdomain.provider.org.dto.OrgEmpRpcDTO;
import com.elitesland.yst.supportdomain.provider.org.param.OrgEmpRpcDtoParam;
import com.elitesland.yst.system.export.convert.SysExportDataConvert;
import com.elitesland.yst.system.export.param.SysUserExportData;
import com.elitesland.yst.system.rmi.support.RmiOrgEmpRpcService;
import com.elitesland.yst.system.service.ISysUserService;
import com.elitesland.yst.system.service.param.SysUserPagingParam;
import com.elitesland.yst.system.service.vo.SysUserPagingVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SysUserExportClient
implements DataExport<SysUserExportData, SysUserPagingParam> {
    private static final Logger log = LoggerFactory.getLogger(SysUserExportClient.class);
    private static final SysExportDataConvert CONVERT = SysExportDataConvert.INSTANCE;
    private final ISysUserService iSysUserService;
    private final RmiOrgEmpRpcService rmiOrgEmpRpcService;

    public String getTmplCode() {
        return "yst_system_user";
    }

    public PagingVO<SysUserExportData> execute(SysUserPagingParam queryParam, int page, int pageSize) {
        queryParam.setCurrent(Integer.valueOf(page));
        queryParam.setSize(Integer.valueOf(pageSize));
        com.elitesland.yst.common.base.PagingVO pageUser = this.iSysUserService.findPaging(queryParam);
        if (CollUtil.isEmpty((Collection)pageUser.getRecords())) {
            return PagingVO.builder().total(pageUser.getTotal()).records(Collections.emptyList()).build();
        }
        List<Long> userIds = pageUser.getRecords().parallelStream().map(SysUserPagingVO::getId).collect(Collectors.toList());
        Map<Long, OrgEmpRpcDTO> empMap = this.queryEmpByUserId(userIds);
        ArrayList<SysUserExportData> dataList = new ArrayList<SysUserExportData>(pageUser.getRecords().size());
        SysUserExportData data = null;
        OrgEmpRpcDTO emp = null;
        for (SysUserPagingVO re : pageUser.getRecords()) {
            data = CONVERT.convertSysUser(re);
            dataList.add(data);
            emp = empMap.get(re.getId());
            if (emp == null) continue;
            data.setEmpCode(emp.getEmpCode());
            data.setEmpName(emp.getEmpName());
            data.setEmpBuName(emp.getBuName());
            data.setEmpOuName(emp.getOuName());
            data.setEmpTypeName(emp.getEmpTypeName());
        }
        return PagingVO.builder().total(pageUser.getTotal()).records(dataList).build();
    }

    public Integer pageSize() {
        return 200;
    }

    private Map<Long, OrgEmpRpcDTO> queryEmpByUserId(List<Long> userIds) {
        OrgEmpRpcDtoParam rpcDtoParam = new OrgEmpRpcDtoParam();
        rpcDtoParam.setUserIds(userIds);
        List<OrgEmpRpcDTO> empList = null;
        try {
            empList = this.rmiOrgEmpRpcService.findEmpDtoByParam(rpcDtoParam);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u652f\u6491\u57df\u67e5\u8be2\u7528\u6237\u7ed1\u5b9a\u7684\u5458\u5de5\u4fe1\u606f\u5f02\u5e38\uff1a", (Throwable)e);
            throw new BusinessException("\u67e5\u8be2\u5458\u5de5\u4fe1\u606f\u5f02\u5e38");
        }
        if (CollUtil.isEmpty(empList)) {
            return Collections.emptyMap();
        }
        return empList.stream().collect(Collectors.toMap(OrgEmpRpcDTO::getUserId, t -> t, (t1, t2) -> t1));
    }

    public SysUserExportClient(ISysUserService iSysUserService, RmiOrgEmpRpcService rmiOrgEmpRpcService) {
        this.iSysUserService = iSysUserService;
        this.rmiOrgEmpRpcService = rmiOrgEmpRpcService;
    }
}

