/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.imports;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import com.el.coordinator.boot.fsm.model.vo.ImportResultRespVO;
import com.el.coordinator.boot.fsm.service.importdata.DataImport;
import com.elitesland.yst.common.constant.Terminal;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.supportdomain.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.yst.supportdomain.provider.org.param.OrgEmpUserRpcParam;
import com.elitesland.yst.supportdomain.provider.org.param.OrgOuRpcDtoParam;
import com.elitesland.yst.system.imports.param.SysUserImportData;
import com.elitesland.yst.system.param.SysUserNewParam;
import com.elitesland.yst.system.rmi.support.RmiOrgEmpRpcService;
import com.elitesland.yst.system.rmi.support.RmiOrgOuRpcService;
import com.elitesland.yst.system.service.ISysDataRoleService;
import com.elitesland.yst.system.service.ISysFlowRoleService;
import com.elitesland.yst.system.service.ISysRoleService;
import com.elitesland.yst.system.service.ISysUserService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SysUserImportClient
implements DataImport<SysUserImportData> {
    private static final Logger log = LoggerFactory.getLogger(SysUserImportClient.class);
    private final Map<String, Terminal> terminalMap = Arrays.stream(Terminal.values()).collect(Collectors.toMap(Terminal::getDescription, t -> t, (t1, t2) -> t1));
    private final ISysUserService sysUserService;
    private final ISysRoleService sysRoleService;
    private final ISysFlowRoleService sysFlowRoleService;
    private final ISysDataRoleService sysDataRoleService;
    private final RmiOrgOuRpcService orgOuRpcService;
    private final RmiOrgEmpRpcService orgEmpRpcService;

    public String getTmplCode() {
        return "yst_system_user_import";
    }

    public ImportResultRespVO.SyncResult execute(List<SysUserImportData> dataList, int startRowIndex) {
        if (CollUtil.isEmpty(dataList)) {
            return ImportResultRespVO.SyncResult.builder().total(Integer.valueOf(0)).numSuccess(Integer.valueOf(0)).failRecords(Collections.emptyList()).build();
        }
        return this.convertUsers(dataList, startRowIndex);
    }

    private ImportResultRespVO.SyncResult convertUsers(List<SysUserImportData> dataList, int startRowIndex) {
        List<String> ouCodes = dataList.parallelStream().map(t -> {
            String c = t.getOuCode();
            Assert.notBlank((CharSequence)c, (String)"\u516c\u53f8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            return c.trim();
        }).distinct().collect(Collectors.toList());
        Map<String, OrgOuRpcDTO> orgOuMap = this.queryOrgOu(ouCodes);
        Set roleNames = dataList.parallelStream().flatMap(t -> this.tokenizer(t.getRoleNames()).stream()).collect(Collectors.toSet());
        Set dataRoleNames = dataList.parallelStream().flatMap(t -> this.tokenizer(t.getDataRoleNames()).stream()).collect(Collectors.toSet());
        Set flowRoleNames = dataList.parallelStream().flatMap(t -> this.tokenizer(t.getFlowRoleNames()).stream()).collect(Collectors.toSet());
        Map roleMap = roleNames.isEmpty() ? Collections.emptyMap() : this.sysRoleService.getIdByName(roleNames);
        Map dataRoleMap = dataRoleNames.isEmpty() ? Collections.emptyMap() : this.sysDataRoleService.getIdByName(dataRoleNames);
        Map flowRoleMap = flowRoleNames.isEmpty() ? Collections.emptyMap() : this.sysFlowRoleService.getIdByName(flowRoleNames);
        ArrayList<String> errorMsgs = new ArrayList<String>();
        HashMap<Long, SysUserImportData> userEmpMap = new HashMap<Long, SysUserImportData>();
        HashSet<String> empCodes = new HashSet<String>();
        int numSuccess = 0;
        SysUserNewParam param = null;
        OrgOuRpcDTO ou = null;
        Object recordPrefix = "";
        for (SysUserImportData data : dataList) {
            recordPrefix = "\u7b2c" + startRowIndex + "\u884c";
            ++startRowIndex;
            if (CharSequenceUtil.isNotBlank((CharSequence)data.getEmpCode())) {
                if (empCodes.contains(data.getEmpCode())) {
                    errorMsgs.add((String)recordPrefix + "\u7684\u5458\u5de5\u7f16\u53f7\u5b58\u5728\u91cd\u590d");
                    continue;
                }
                empCodes.add(data.getEmpCode());
            }
            param = new SysUserNewParam();
            param.setUsername(data.getUsername());
            param.setLastName(data.getLastName());
            param.setFirstName(data.getFirstName());
            param.setMobile(data.getMobile());
            param.setEmail(data.getEmail());
            param.setEnabled(Boolean.valueOf(true));
            OrgOuRpcDTO orgOuRpcDTO = ou = CharSequenceUtil.isBlank((CharSequence)data.getOuCode()) ? null : orgOuMap.get(data.getOuCode().trim());
            if (ou == null) {
                errorMsgs.add((String)recordPrefix + "\u6240\u5c5e\u516c\u53f8\u8bbe\u7f6e\u6709\u8bef");
                continue;
            }
            param.setOuId(ou.getId());
            param.setOuCode(ou.getOuCode());
            param.setOuName(ou.getOuName());
            param.setRoleIds(this.nameToId(data.getRoleNames(), roleMap));
            param.setDataRoleIds(this.nameToId(data.getDataRoleNames(), dataRoleMap));
            param.setFlowRoleIds(this.nameToId(data.getFlowRoleNames(), flowRoleMap));
            param.setSourceType("oth");
            param.setTerminals(this.convertTerminal(data.getTerminalNames()));
            try {
                Long userId = this.sysUserService.create(param, null);
                userEmpMap.put(userId, data);
            }
            catch (Exception e) {
                log.error("\u5bfc\u5165\u7528\u6237\u65f6\u4fdd\u5b58\u7528\u6237\u5f02\u5e38\uff1a", (Throwable)e);
                String msg = e instanceof BusinessException ? e.getMessage() : "\u4fdd\u5b58\u5931\u8d25";
                errorMsgs.add((String)recordPrefix + msg);
                continue;
            }
            ++numSuccess;
        }
        this.saveEmpInfo(userEmpMap, errorMsgs);
        return ImportResultRespVO.SyncResult.builder().total(Integer.valueOf(dataList.size())).numSuccess(Integer.valueOf(numSuccess)).failRecords(errorMsgs).build();
    }

    private void saveEmpInfo(Map<Long, SysUserImportData> userEmpMap, List<String> errorMsgs) {
        if (userEmpMap.isEmpty()) {
            return;
        }
        List<OrgEmpUserRpcParam> empList = userEmpMap.entrySet().stream().filter(t -> t.getKey() != null && CharSequenceUtil.isNotBlank((CharSequence)((SysUserImportData)t.getValue()).getEmpCode())).map(t -> {
            OrgEmpUserRpcParam rpcParam = new OrgEmpUserRpcParam();
            rpcParam.setUserId((Long)t.getKey());
            rpcParam.setUserName(CharSequenceUtil.blankToDefault((CharSequence)((SysUserImportData)t.getValue()).getUsername(), (String)""));
            rpcParam.setEmpCode(((SysUserImportData)t.getValue()).getEmpCode());
            return rpcParam;
        }).collect(Collectors.toList());
        if (CollUtil.isEmpty(empList)) {
            return;
        }
        Object errorMsg = null;
        try {
            errorMsg = this.orgEmpRpcService.userExportBindEmp(empList);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u652f\u6491\u57df\u4fdd\u5b58\u7528\u6237\u4e0e\u5458\u5de5\u7684\u7ed1\u5b9a\u4fe1\u606f\u5931\u8d25\uff1a", (Throwable)e);
            errorMsg = "\u4fdd\u5b58\u7528\u6237\u4e0e\u5458\u5de5\u7684\u7ed1\u5b9a\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage();
        }
        if (errorMsg != null) {
            errorMsgs.add((String)errorMsg);
        }
    }

    private Set<String> findLack(Set<String> original, Set<String> target) {
        if (target.isEmpty()) {
            return original;
        }
        return original.stream().filter(t -> !target.contains(t)).collect(Collectors.toSet());
    }

    private Map<String, OrgOuRpcDTO> queryOrgOu(List<String> ouCodes) {
        if (ouCodes.isEmpty()) {
            return Collections.emptyMap();
        }
        OrgOuRpcDtoParam param = new OrgOuRpcDtoParam();
        param.setOuCodes(ouCodes);
        List<OrgOuRpcDTO> dtoList = null;
        try {
            dtoList = this.orgOuRpcService.findOuDtoByParam(param);
        }
        catch (Exception e) {
            log.error("\u5bfc\u5165\u7528\u6237\u65f6\u67e5\u8be2\u6240\u5c5e\u516c\u53f8\u5f02\u5e38\uff1a", (Throwable)e);
            throw new RuntimeException("\u5bfc\u5165\u7528\u6237\u65f6\u67e5\u8be2\u6240\u5c5e\u516c\u53f8\u5f02\u5e38");
        }
        if (CollUtil.isEmpty(dtoList)) {
            return Collections.emptyMap();
        }
        return dtoList.stream().collect(Collectors.toMap(OrgOuRpcDTO::getOuCode, t -> t, (t1, t2) -> t1));
    }

    private List<Long> nameToId(String names, Map<String, Long> nameMap) {
        Set<String> nameSet = this.tokenizer(names);
        if (nameSet.isEmpty()) {
            return Collections.emptyList();
        }
        return nameSet.stream().map(nameMap::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Set<Terminal> convertTerminal(String names) {
        Set<String> terminals = this.tokenizer(names);
        if (terminals.isEmpty()) {
            return Collections.emptySet();
        }
        return terminals.stream().map(this.terminalMap::get).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private Set<String> tokenizer(String str) {
        if (CharSequenceUtil.isBlank((CharSequence)str)) {
            return Collections.emptySet();
        }
        StringTokenizer tokens = new StringTokenizer(str, ",;\uff0c\uff1b");
        HashSet<String> valueSet = new HashSet<String>();
        while (tokens.hasMoreTokens()) {
            valueSet.add(tokens.nextToken().trim());
        }
        return valueSet;
    }

    public SysUserImportClient(ISysUserService sysUserService, ISysRoleService sysRoleService, ISysFlowRoleService sysFlowRoleService, ISysDataRoleService sysDataRoleService, RmiOrgOuRpcService orgOuRpcService, RmiOrgEmpRpcService orgEmpRpcService) {
        this.sysUserService = sysUserService;
        this.sysRoleService = sysRoleService;
        this.sysFlowRoleService = sysFlowRoleService;
        this.sysDataRoleService = sysDataRoleService;
        this.orgOuRpcService = orgOuRpcService;
        this.orgEmpRpcService = orgEmpRpcService;
    }
}

