/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.log.service.impl;

import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.system.log.convert.AccessLogConvert;
import com.elitesland.yst.system.log.model.entity.AccessLogDO;
import com.elitesland.yst.system.log.model.vo.AccessLogDetailVO;
import com.elitesland.yst.system.log.model.vo.AccessLogListVO;
import com.elitesland.yst.system.log.model.vo.query.AccessLogQueryVO;
import com.elitesland.yst.system.log.service.AccessLogService;
import com.elitesland.yst.system.log.service.repo.AccessLogRepo;
import com.elitesland.yst.system.log.service.repo.AccessLogRepoProc;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.stereotype.Service;

@Service
public class AccessLogServiceImpl
implements AccessLogService {
    private static final Logger log = LogManager.getLogger(AccessLogServiceImpl.class);
    private static final AccessLogConvert CONVERT = AccessLogConvert.INSTANCE;
    private final ObjectMapper objectMapper = this.buildObjectMapper();
    @Autowired
    private AccessLogRepo accessLogRepo;
    @Autowired
    private AccessLogRepoProc accessLogRepoProc;

    @Override
    public ApiResult<PagingVO<AccessLogListVO>> query(AccessLogQueryVO queryVO) {
        PagingVO<AccessLogListVO> pageResult = this.accessLogRepoProc.query(queryVO);
        return ApiResult.ok(pageResult);
    }

    @Override
    public ApiResult<AccessLogDetailVO> get(Long id) {
        if (id == null) {
            return ApiResult.fail((String)"ID\u4e3a\u7a7a");
        }
        AccessLogDO doo = this.accessLogRepoProc.get(id);
        if (doo == null) {
            return ApiResult.fail((String)"\u8bf7\u6c42\u6570\u636e\u4e0d\u5b58\u5728");
        }
        return ApiResult.ok((Object)CONVERT.do2DetailVo(doo));
    }

    private ObjectMapper buildObjectMapper() {
        return new Jackson2ObjectMapperBuilder().serializerByType(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"))).serializerByType(LocalDate.class, (JsonSerializer)new LocalDateSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd"))).build();
    }
}

