/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.log.service.repo;

import com.blazebit.persistence.CriteriaBuilderFactory;
import com.blazebit.persistence.PagedList;
import com.blazebit.persistence.querydsl.BlazeJPAQuery;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.system.log.model.entity.AccessLogDO;
import com.elitesland.yst.system.log.model.entity.QAccessLogDO;
import com.elitesland.yst.system.log.model.vo.AccessLogListVO;
import com.elitesland.yst.system.log.model.vo.query.AccessLogQueryVO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class AccessLogRepoProc {
    private static final QAccessLogDO QDO = QAccessLogDO.accessLogDO;
    private PathBuilder<?> pathBuilder;
    @Autowired
    private JPAQueryFactory jpaQueryFactory;
    @Autowired
    private EntityManager entityManager;
    @Autowired
    private CriteriaBuilderFactory criteriaBuilderFactory;

    public AccessLogDO get(Long id) {
        return (AccessLogDO)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)QDO).from((EntityPath)QDO)).where((Predicate)AccessLogRepoProc.QDO.id.eq((Object)id))).fetchOne();
    }

    public PagingVO<AccessLogListVO> query(AccessLogQueryVO queryVO) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>(16);
        if (queryVO.getRequestTimeStart() != null) {
            predicates.add(AccessLogRepoProc.QDO.requestTime.after((Comparable)queryVO.getRequestTimeStart()));
        }
        if (queryVO.getRequestTimeEnd() != null) {
            predicates.add(AccessLogRepoProc.QDO.requestTime.before((Comparable)queryVO.getRequestTimeEnd()));
        }
        if (queryVO.getCostMin() != null) {
            predicates.add(AccessLogRepoProc.QDO.cost.goe((Number)queryVO.getCostMin()));
        }
        if (queryVO.getCostMin() != null) {
            predicates.add(AccessLogRepoProc.QDO.cost.loe((Number)queryVO.getCostMax()));
        }
        if (StringUtils.hasText((String)queryVO.getRoute())) {
            predicates.add(AccessLogRepoProc.QDO.route.eq((Object)queryVO.getRoute()));
        }
        if (StringUtils.hasText((String)queryVO.getUsername())) {
            predicates.add(AccessLogRepoProc.QDO.username.eq((Object)queryVO.getUsername()));
        }
        if (StringUtils.hasText((String)queryVO.getClient())) {
            predicates.add(AccessLogRepoProc.QDO.client.eq((Object)queryVO.getClient()));
        }
        if (StringUtils.hasText((String)queryVO.getAppCode())) {
            predicates.add(AccessLogRepoProc.QDO.appCode.eq((Object)queryVO.getAppCode()));
        }
        if (queryVO.getResultCode() != null) {
            predicates.add(AccessLogRepoProc.QDO.resultCode.eq((Object)queryVO.getResultCode()));
        }
        if (queryVO.getSuccess() != null) {
            predicates.add(AccessLogRepoProc.QDO.success.eq(queryVO.getSuccess()));
        }
        Predicate predicate = ExpressionUtils.allOf(predicates);
        PageRequest pageRequest = queryVO.getPageRequest();
        BlazeJPAQuery jpaQuery = new BlazeJPAQuery(this.entityManager, this.criteriaBuilderFactory);
        PagedList pageList = ((BlazeJPAQuery)((BlazeJPAQuery)((BlazeJPAQuery)jpaQuery.select(this.fieldsOfList()).from((EntityPath)QDO)).where(predicate)).orderBy(this.obtainOrders(pageRequest))).fetchPage((int)pageRequest.getOffset(), pageRequest.getPageSize());
        return PagingVO.builder().total(Long.valueOf(pageList.getTotalSize())).records((List)pageList).build();
    }

    private OrderSpecifier<?>[] obtainOrders(PageRequest pageRequest) {
        Sort sort = pageRequest.getSort();
        if (sort.isUnsorted()) {
            return new OrderSpecifier[]{new OrderSpecifier(Order.DESC, AccessLogRepoProc.QDO.requestTime), new OrderSpecifier(Order.DESC, AccessLogRepoProc.QDO.id)};
        }
        sort = sort.and(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"}));
        return (OrderSpecifier[])sort.stream().map(o -> new OrderSpecifier(o.isAscending() ? Order.ASC : Order.DESC, this.convertFieldExpression(o.getProperty()))).toArray(OrderSpecifier[]::new);
    }

    private Expression<?> convertFieldExpression(String field) {
        if (this.pathBuilder == null) {
            this.pathBuilder = new PathBuilder(((Object)((Object)QDO)).getClass(), QDO.getMetadata());
        }
        return this.pathBuilder.get(field);
    }

    private QBean<AccessLogListVO> fieldsOfList() {
        return Projections.bean(AccessLogListVO.class, (Expression[])new Expression[]{AccessLogRepoProc.QDO.id, AccessLogRepoProc.QDO.requestTime, AccessLogRepoProc.QDO.responseTime, AccessLogRepoProc.QDO.cost, AccessLogRepoProc.QDO.uri, AccessLogRepoProc.QDO.username, AccessLogRepoProc.QDO.client, AccessLogRepoProc.QDO.appCode, AccessLogRepoProc.QDO.resultCode, AccessLogRepoProc.QDO.success});
    }
}

