/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.manager;

import com.elitesland.cloudt.context.redis.RedisWrapper;
import com.elitesland.yst.common.util.RedisUtils;
import com.elitesland.yst.core.provider.tenant.TenantDataIsolateProvider;
import com.elitesland.yst.core.security.common.SysPermTypeEnum;
import com.elitesland.yst.core.security.permission.PermissionActionBO;
import com.elitesland.yst.core.security.util.SecurityUtil;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import com.elitesland.yst.system.convert.SysPermissionConvert;
import com.elitesland.yst.system.dto.SysTenantDTO;
import com.elitesland.yst.system.model.bo.SysPermissionBO;
import com.elitesland.yst.system.model.bo.SysRoleBO;
import com.elitesland.yst.system.model.entity.SysPermissionDO;
import com.elitesland.yst.system.repo.SysPermissionRepoProc;
import com.elitesland.yst.system.repo.SysRolePermissionRepoProc;
import com.elitesland.yst.system.repo.SysRoleRepoProc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class PermissionCacheManager {
    private static final Logger log = LogManager.getLogger(PermissionCacheManager.class);
    private static final String CACHE_ROLE_PERMISSION = "role_permission";
    private static final String CACHE_ROLE_PERMISSION_MENU = "role_permission_menu";
    private static final String CACHE_ROLE_PERMISSION_ACTION = "role_permission_action";
    private static final String CACHE_PERMISSION_ACTION_ROLE = "permission_action_role";
    private static final SysPermissionConvert PERMISSION_CONVERT = SysPermissionConvert.INSTANCE;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private SysPermissionRepoProc permissionRepoProc;
    @Autowired
    private SysRolePermissionRepoProc rolePermissionRepoProc;
    @Autowired
    private SysRoleRepoProc roleRepoProc;
    @Autowired
    private TenantDataIsolateProvider tenantDataIsolateProvider;
    @Autowired
    private RedisWrapper redisWrapper;

    public Map<Long, List<SysPermissionBO>> getRoleWithPermission(SysPermTypeEnum permTypeEnum) {
        String cacheKey = null;
        cacheKey = permTypeEnum == null ? CACHE_ROLE_PERMISSION : (permTypeEnum == SysPermTypeEnum.MENU ? CACHE_ROLE_PERMISSION_MENU : CACHE_ROLE_PERMISSION_ACTION);
        Map data = (Map)this.redisUtils.get(cacheKey);
        if (data != null) {
            return data;
        }
        this.taskExecutor.execute(this::updateRoleWithPermissionCache);
        return Collections.emptyMap();
    }

    public List<PermissionActionBO> getPermissionActions() {
        List permissionActionList = (List)this.redisUtils.get(CACHE_PERMISSION_ACTION_ROLE);
        if (permissionActionList != null) {
            return permissionActionList;
        }
        this.taskExecutor.execute(this::updateRoleWithPermissionCache);
        return Collections.emptyList();
    }

    public void clearPermissionCache() {
        this.clearAllCache();
        List allTenants = this.tenantDataIsolateProvider.getAllTenant();
        for (SysTenantDTO tenantDTO : allTenants) {
            try {
                this.redisWrapper.apply(() -> {
                    this.clearAllCache();
                    return null;
                }, (Object)tenantDTO);
            }
            catch (Exception e) {
                log.error("\u6e05\u7406\u79df\u6237\u3010{}, {}\u3011\u6743\u9650\u7f13\u5b58\u5931\u8d25", (Object)tenantDTO.getTenantName(), (Object)tenantDTO.getId());
            }
        }
    }

    private void clearAllCache() {
        this.redisUtils.del(new String[]{CACHE_ROLE_PERMISSION});
        this.redisUtils.del(new String[]{CACHE_ROLE_PERMISSION_MENU});
        this.redisUtils.del(new String[]{CACHE_ROLE_PERMISSION_ACTION});
        this.redisUtils.del(new String[]{CACHE_PERMISSION_ACTION_ROLE});
    }

    private void updateRoleWithPermissionCache() {
        GeneralUserDetails user = SecurityUtil.getUser();
        if (user == null) {
            log.warn("\u672a\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f\uff0c\u66f4\u65b0\u89d2\u8272\u6743\u9650\u7f13\u5b58\u5931\u8d25");
            return;
        }
        log.info("\u66f4\u65b0\u89d2\u8272\u6743\u9650\u7f13\u5b58\uff1a{}", (Object)user.getTenantId());
        List<SysPermissionBO> permissions = this.queryPermissions();
        if (permissions.isEmpty()) {
            return;
        }
        this.tenantDataIsolateProvider.byTenantUser(() -> {
            this.updateTenantRoleWithPermissionCache(permissions, user);
            return null;
        }, user.getUser());
    }

    private void updateTenantRoleWithPermissionCache(List<SysPermissionBO> permissions, GeneralUserDetails userDetails) {
        HashMap<Long, SysPermissionBO> permissionMap = new HashMap<Long, SysPermissionBO>(permissions.size());
        HashMap<Long, PermissionActionBO> permissionActionMap = new HashMap<Long, PermissionActionBO>();
        for (SysPermissionBO permission : permissions) {
            permissionMap.put(permission.getId(), permission);
            if (!SysPermTypeEnum.ACTION.getValue().equals(permission.getPermType()) || !StringUtils.hasText((String)permission.getPattern())) continue;
            PermissionActionBO bo = new PermissionActionBO();
            bo.setId(permission.getId());
            bo.setPattern(permission.getPattern());
            bo.setHttpMethod(permission.getHttpMethod());
            bo.setRoleCodes(new HashSet());
            permissionActionMap.put(permission.getId(), bo);
        }
        ArrayList permissionActionList = new ArrayList(permissionActionMap.values());
        Map<Long, SysRoleBO> roleMap = this.roleRepoProc.query(null).stream().filter(t -> Boolean.TRUE.equals(t.getEnabled())).collect(Collectors.toMap(SysRoleBO::getId, t -> t, (t1, t2) -> t1));
        if (roleMap.isEmpty()) {
            log.warn("\u672a\u83b7\u53d6\u5230\u89d2\u8272\u4fe1\u606f");
            this.cache(userDetails, CACHE_PERMISSION_ACTION_ROLE, permissionActionList);
            return;
        }
        Map<Long, Set<Long>> rolePermissionMap = this.rolePermissionRepoProc.queryRoleWithPermission(null);
        if (rolePermissionMap.isEmpty()) {
            log.warn("\u65e0\u89d2\u8272\u6743\u9650\u7ed1\u5b9a");
            this.cache(userDetails, CACHE_PERMISSION_ACTION_ROLE, permissionActionList);
            return;
        }
        HashMap<Long, List> rolePermissionsMap = new HashMap<Long, List>();
        HashMap<Long, List> rolePermissionMenusMap = new HashMap<Long, List>();
        HashMap<Long, List> rolePermissionActionsMap = new HashMap<Long, List>();
        for (Map.Entry<Long, Set<Long>> bind : rolePermissionMap.entrySet()) {
            Long roleId = bind.getKey();
            SysRoleBO role = roleMap.get(roleId);
            if (role == null) continue;
            for (Long permissionId : bind.getValue()) {
                SysPermissionBO permission = (SysPermissionBO)permissionMap.get(permissionId);
                if (permission == null) {
                    log.error("\u6743\u9650\u3010{}\u3011\u4e0d\u5b58\u5728", (Object)permissionId);
                    continue;
                }
                rolePermissionsMap.computeIfAbsent(roleId, k -> new ArrayList()).add(permission);
                if (SysPermTypeEnum.MENU.getValue().equals(permission.getPermType())) {
                    rolePermissionMenusMap.computeIfAbsent(roleId, k -> new ArrayList()).add(permission);
                    continue;
                }
                if (SysPermTypeEnum.ACTION.getValue().equals(permission.getPermType())) {
                    rolePermissionActionsMap.computeIfAbsent(roleId, k -> new ArrayList()).add(permission);
                    PermissionActionBO actionBO = (PermissionActionBO)permissionActionMap.get(permissionId);
                    if (actionBO == null) continue;
                    actionBO.getRoleCodes().add(role.getCode());
                    continue;
                }
                log.error("\u6743\u9650\u3010{}\u3011\u7684\u7c7b\u578b\u3010{}\u3011\u4e0d\u652f\u6301\uff01", (Object)permissionId, (Object)permission.getPermType());
            }
        }
        this.cache(userDetails, CACHE_ROLE_PERMISSION, rolePermissionsMap);
        this.cache(userDetails, CACHE_ROLE_PERMISSION_MENU, rolePermissionMenusMap);
        this.cache(userDetails, CACHE_ROLE_PERMISSION_ACTION, rolePermissionActionsMap);
        this.cache(userDetails, CACHE_PERMISSION_ACTION_ROLE, permissionActionList);
    }

    private List<SysPermissionBO> queryPermissions() {
        List<SysPermissionDO> permissions = this.permissionRepoProc.queryAll();
        if (permissions.isEmpty()) {
            log.warn("\u672a\u67e5\u8be2\u5230\u6743\u9650\u4fe1\u606f");
            return Collections.emptyList();
        }
        return permissions.stream().map(PERMISSION_CONVERT::do2Bo).collect(Collectors.toList());
    }

    private void cache(GeneralUserDetails user, String key, Object value) {
        if (user.isTenantUser()) {
            try {
                this.redisWrapper.apply(() -> {
                    this.redisUtils.set(key, value);
                    return null;
                }, (Object)user);
            }
            catch (Exception e) {
                log.error("\u7f13\u5b58\u6743\u9650\u4fe1\u606f\u5931\u8d25\uff1a", (Throwable)e);
            }
            return;
        }
        this.redisUtils.set(key, value);
    }
}

