/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.manager;

import cn.hutool.core.util.ObjectUtil;
import com.elitesland.yst.core.annotation.TenantTransaction;
import com.elitesland.yst.core.annotation.common.TenantIsolateType;
import com.elitesland.yst.core.security.common.SysPermTypeEnum;
import com.elitesland.yst.system.convert.SysPermissionConvert;
import com.elitesland.yst.system.model.bo.SysPermissionBO;
import com.elitesland.yst.system.model.bo.SysRoleBO;
import com.elitesland.yst.system.model.entity.SysPermissionDO;
import com.elitesland.yst.system.repo.SysPermissionRepoProc;
import com.elitesland.yst.system.repo.SysRolePermissionRepoProc;
import com.elitesland.yst.system.repo.SysRoleRepoProc;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PermissionManager {
    private static final SysPermissionConvert CONVERT = SysPermissionConvert.INSTANCE;
    @Autowired
    private SysPermissionRepoProc permissionRepoProc;
    @Autowired
    private SysRolePermissionRepoProc rolePermissionRepoProc;
    @Autowired
    private SysRoleRepoProc roleRepoProc;

    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    public List<SysPermissionBO> queryPermissions(SysPermTypeEnum permTypeEnum) {
        List permissions = this.permissionRepoProc.all();
        return this.convertBo(permissions, permTypeEnum);
    }

    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    public List<SysPermissionBO> queryPermissionsByParent(Long parentId, SysPermTypeEnum permTypeEnum) {
        List<SysPermissionDO> permissions = this.permissionRepoProc.queryByParent(parentId);
        return this.convertBo(permissions, permTypeEnum);
    }

    public List<SysRoleBO> queryRoles(Set<Long> roleIds) {
        return this.roleRepoProc.query(roleIds).stream().filter(t -> Boolean.TRUE.equals(t.getEnabled())).collect(Collectors.toList());
    }

    public List<SysRoleBO> queryRoles(Set<Long> roleIds, List<SysPermissionBO> sysPermissionBOList) {
        List<SysRoleBO> roles = this.queryRoles(roleIds);
        if (sysPermissionBOList.isEmpty()) {
            return roles;
        }
        Map<Long, Set<Long>> rolePermissions = this.rolePermissionRepoProc.queryRoleWithPermission(roleIds);
        if (rolePermissions.isEmpty()) {
            return roles;
        }
        Map<Long, SysPermissionBO> permissionMap = sysPermissionBOList.stream().collect(Collectors.toMap(SysPermissionBO::getId, t -> t, (t1, t2) -> t1));
        for (SysRoleBO role : roles) {
            Set<Long> permissionIds = rolePermissions.get(role.getId());
            if (permissionIds == null) continue;
            List<SysPermissionBO> permissions = permissionIds.stream().filter(permissionMap::containsKey).map(permissionMap::get).collect(Collectors.toList());
            role.setPermissions(permissions);
        }
        return roles;
    }

    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    public List<SysRoleBO> queryRolesForAdmin(Set<Long> roleIds, List<SysPermissionBO> sysPermissionBOList) {
        List<SysRoleBO> roles = this.queryRoles(roleIds);
        if (sysPermissionBOList.isEmpty()) {
            return roles;
        }
        roles.get(0).setPermissions(sysPermissionBOList);
        return roles;
    }

    private List<SysPermissionBO> convertBo(List<SysPermissionDO> permissions, SysPermTypeEnum permTypeEnum) {
        if (permissions.isEmpty()) {
            return Collections.emptyList();
        }
        return permissions.stream().filter(t -> {
            boolean notDelete;
            boolean bl = notDelete = t.getDeleteFlag() == null || t.getDeleteFlag() == 0;
            if (permTypeEnum == null) {
                return notDelete;
            }
            return permTypeEnum.getValue().intValue() == ((Integer)ObjectUtil.defaultIfNull((Object)t.getPermType(), (Object)-1)).intValue() && notDelete;
        }).map(CONVERT::do2Bo).collect(Collectors.toList());
    }
}

