/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.manager;

import cn.hutool.core.util.ObjectUtil;
import com.elitesland.yst.core.provider.tenant.TenantDataIsolateProvider;
import com.elitesland.yst.core.security.common.SysPermTypeEnum;
import com.elitesland.yst.core.security.component.PermissionWithRoleCacheService;
import com.elitesland.yst.core.util.TreeDataUtil;
import com.elitesland.yst.security.common.InnerUserEnum;
import com.elitesland.yst.system.manager.PermissionManager;
import com.elitesland.yst.system.model.bo.SysPermissionBO;
import com.elitesland.yst.system.model.bo.SysRoleBO;
import com.elitesland.yst.system.service.ISysUserDataRoleService;
import com.elitesland.yst.system.service.ISysUserRoleService;
import com.elitesland.yst.system.service.vo.SysCurrentUserPermissions;
import com.elitesland.yst.system.vo.AntTreeNode;
import com.elitesland.yst.system.vo.SysRoleVO;
import com.elitesland.yst.system.vo.SysUserDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class UserPermissionManager {
    private static final Logger log = LogManager.getLogger(UserPermissionManager.class);
    @Autowired
    private ISysUserRoleService sysUserRoleService;
    @Autowired
    private ISysUserDataRoleService sysUserDataRoleService;
    @Autowired
    private PermissionWithRoleCacheService permissionWithRoleCacheService;
    @Autowired
    private PermissionManager permissionManager;
    @Autowired
    private TenantDataIsolateProvider tenantDataIsolateProvider;

    public void fillRoleForUser(SysUserDTO user, List<Long> userIds) {
        Set userRoles = this.sysUserRoleService.listDistinctRolesByUserIds(userIds.stream().distinct().collect(Collectors.toList())).stream().filter(t -> Boolean.TRUE.equals(t.getEnabled())).collect(Collectors.toSet());
        user.setRoles(userRoles);
        Set userDataRoles = this.sysUserDataRoleService.listDataRolesByUserId(user.getId()).stream().filter(t -> Boolean.TRUE.equals(t.getEnabled())).collect(Collectors.toSet());
        user.setSysDataRoleVOS(userDataRoles);
    }

    public List<SysRoleBO> queryUserRolesWithPermission(SysUserDTO userDetails, SysPermTypeEnum permType, Long parentId) {
        List<SysPermissionBO> permissions;
        if (userDetails == null || CollectionUtils.isEmpty((Collection)userDetails.getRoles())) {
            return Collections.emptyList();
        }
        List<SysPermissionBO> list = permissions = parentId == null ? this.permissionManager.queryPermissions(permType) : this.permissionManager.queryPermissionsByParent(parentId, permType);
        if (permissions.isEmpty()) {
            return Collections.emptyList();
        }
        Set roleIds = userDetails.getRoles().stream().filter(t -> Boolean.TRUE.equals(t.getEnabled())).map(SysRoleVO::getId).collect(Collectors.toSet());
        return (List)this.tenantDataIsolateProvider.byTenantUser(() -> {
            if (InnerUserEnum.ADMIN.getUsername().equals(userDetails.getUsername())) {
                return this.permissionManager.queryRolesForAdmin(roleIds, permissions);
            }
            return this.permissionManager.queryRoles(roleIds, permissions);
        }, userDetails);
    }

    public List<AntTreeNode> queryUserPermissionMenuTree(SysUserDTO userDetails) {
        List<SysRoleBO> roles = this.queryUserRolesWithPermission(userDetails, SysPermTypeEnum.MENU, null);
        if (roles.isEmpty()) {
            return Collections.emptyList();
        }
        return this.convertTree(roles);
    }

    public List<SysCurrentUserPermissions> queryUserPermissionList(SysUserDTO userDetails, SysPermTypeEnum permType) {
        List<SysRoleBO> roles = this.queryUserRolesWithPermission(userDetails, permType, null);
        if (roles.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SysCurrentUserPermissions> permissions = new ArrayList<SysCurrentUserPermissions>();
        HashSet<Long> exists = new HashSet<Long>();
        for (SysRoleBO role : roles) {
            for (SysPermissionBO per : role.getPermissions()) {
                if (exists.contains(per.getId())) continue;
                exists.add(per.getId());
                SysCurrentUserPermissions permission = this.rolePermission2Permission(per);
                permissions.add(permission);
            }
        }
        return permissions;
    }

    public List<SysCurrentUserPermissions> queryUserPermissionMenuTree1(SysUserDTO userDetails) {
        List<SysCurrentUserPermissions> permissions = this.queryUserPermissionList(userDetails, SysPermTypeEnum.MENU);
        TreeDataUtil treeDataUtil = new TreeDataUtil(permissions, SysCurrentUserPermissions::getId, SysCurrentUserPermissions::getParentId, SysCurrentUserPermissions::setChildNodes, Comparator.comparingInt(SysCurrentUserPermissions::getSortNo));
        return treeDataUtil.getRoots().stream().filter(t -> t.getParentId() == 0L).collect(Collectors.toList());
    }

    public List<SysCurrentUserPermissions> queryUserPermissionMenuTreeset(SysUserDTO userDetails) {
        List<SysCurrentUserPermissions> permissions = this.queryUserPermissionList(userDetails, SysPermTypeEnum.MENU);
        return permissions;
    }

    public List<SysCurrentUserPermissions> queryUserPermissionActionList(SysUserDTO userDetails, Long menuId) {
        if (menuId == null) {
            return this.queryUserPermissionList(userDetails, SysPermTypeEnum.ACTION);
        }
        List<SysRoleBO> rolePermissions = this.queryUserRolesWithPermission(userDetails, SysPermTypeEnum.ACTION, menuId);
        if (rolePermissions.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SysCurrentUserPermissions> permissions = new ArrayList<SysCurrentUserPermissions>();
        HashSet<Long> exists = new HashSet<Long>();
        for (SysRoleBO rolePermission : rolePermissions) {
            for (SysPermissionBO per : rolePermission.getPermissions()) {
                if (exists.contains(per.getId())) continue;
                exists.add(per.getId());
                SysCurrentUserPermissions permission = this.rolePermission2Permission(per);
                permissions.add(permission);
            }
        }
        return permissions;
    }

    private List<AntTreeNode> convertTree(List<SysRoleBO> roles) {
        ArrayList permissions = roles.stream().flatMap(t -> t.getPermissions() == null ? Stream.empty() : t.getPermissions().stream().map(this::role2TreeNode)).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<AntTreeNode>(Comparator.comparing(AntTreeNode::getKey))), ArrayList::new));
        if (permissions.isEmpty()) {
            return Collections.emptyList();
        }
        TreeDataUtil treeDataUtil = new TreeDataUtil((List)permissions, AntTreeNode::getKey, AntTreeNode::getParentKey, AntTreeNode::setChildren, Comparator.comparingInt(AntTreeNode::getSortNo));
        return treeDataUtil.getRoots().stream().filter(t -> t.getParentKey() == 0L).collect(Collectors.toList());
    }

    private AntTreeNode role2TreeNode(SysPermissionBO permissionBO) {
        AntTreeNode antTreeNode = new AntTreeNode();
        antTreeNode.setKey(permissionBO.getId());
        antTreeNode.setCode(permissionBO.getCode());
        antTreeNode.setTitle(permissionBO.getName());
        antTreeNode.setLevel(permissionBO.getPermLevel());
        antTreeNode.setParentKey((Long)ObjectUtil.defaultIfNull((Object)permissionBO.getParentId(), (Object)0L));
        antTreeNode.setSortNo((Integer)ObjectUtil.defaultIfNull((Object)permissionBO.getSortNo(), (Object)0));
        antTreeNode.setIcon(permissionBO.getIcon());
        antTreeNode.setChildren(Collections.emptyList());
        antTreeNode.setTerminalCode(permissionBO.getTerminalCode());
        antTreeNode.setIsQuick(Boolean.valueOf(permissionBO.getIsQuick() != null && permissionBO.getIsQuick() != false));
        return antTreeNode;
    }

    private SysCurrentUserPermissions rolePermission2Permission(SysPermissionBO per) {
        SysCurrentUserPermissions permission = new SysCurrentUserPermissions();
        permission.setId(per.getId());
        permission.setParentId(per.getParentId());
        permission.setCode(per.getCode());
        permission.setName(per.getName());
        permission.setSortNo((Integer)ObjectUtil.defaultIfNull((Object)per.getSortNo(), (Object)0));
        permission.setPattern(per.getPattern());
        permission.setIsHidden(Boolean.valueOf(per.getIsHidden() != null && per.getIsHidden() != false));
        permission.setIcon(per.getIcon());
        permission.setTerminalCode(per.getTerminalCode());
        permission.setIsQuick(Boolean.valueOf(per.getIsQuick() != null && per.getIsQuick() != false));
        return permission;
    }
}

