/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.manager;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.RandomUtil;
import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.common.util.RedisUtils;
import com.elitesland.yst.coord.messenger.sender.provider.MsgCarrierDubboService;
import com.elitesland.yst.coord.messenger.sender.provider.param.GeneralDubboCarrier;
import com.elitesland.yst.system.service.param.SysSendVerifyCodeParam;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class VerifyCodeManager {
    private static final Logger log = LoggerFactory.getLogger(VerifyCodeManager.class);
    @Autowired
    private RedisUtils redisUtils;
    @DubboReference
    private MsgCarrierDubboService msgCarrierDubboService;

    public String send(String businessType, SysSendVerifyCodeParam verifyCodeParam) {
        Assert.hasText((String)businessType, (String)"\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)verifyCodeParam, (String)"\u53c2\u6570\u4e3a\u7a7a");
        String cacheKey = businessType + "_" + verifyCodeParam.getAccount();
        Object codeOld = this.redisUtils.get(cacheKey);
        if (codeOld != null) {
            throw new BusinessException("\u9a8c\u8bc1\u7801\u53d1\u9001\u8fc7\u4e8e\u9891\u7e41");
        }
        String verifyCode = RandomUtil.randomStringUpper((int)4);
        long period = NumberUtil.max((long[])new long[]{(Long)ObjectUtil.defaultIfNull((Object)verifyCodeParam.getPeriod(), (Object)60L), 30L});
        this.redisUtils.set(cacheKey, (Object)verifyCode, period, TimeUnit.SECONDS);
        ArrayList<GeneralDubboCarrier> carriers = new ArrayList<GeneralDubboCarrier>(4);
        GeneralDubboCarrier generalDubboCarrier = new GeneralDubboCarrier();
        generalDubboCarrier.setTos(new String[]{verifyCodeParam.getAccount()});
        generalDubboCarrier.setPureContent("\u60a8\u7684\u77ed\u4fe1\u9a8c\u8bc1\u7801\u662f\uff1a" + verifyCode);
        generalDubboCarrier.setIsRichContent(Boolean.valueOf(false));
        generalDubboCarrier.setTransType("SMS");
        carriers.add(generalDubboCarrier);
        try {
            ApiResult sendResult = this.msgCarrierDubboService.generalSend(carriers);
            if (sendResult != null && sendResult.isSuccess()) {
                return verifyCode;
            }
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u7801\u5931\u8d25", (Throwable)e);
        }
        this.redisUtils.del(new String[]{cacheKey});
        return null;
    }

    public String verify(String businessType, String account, String verifyCode) {
        Assert.hasText((String)businessType, (String)"\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)account, (String)"\u8d26\u53f7\u4e3a\u7a7a");
        Assert.notNull((Object)verifyCode, (String)"\u9a8c\u8bc1\u7801\u4e3a\u7a7a");
        String cacheKey = businessType + "_" + account;
        String code = (String)this.redisUtils.get(cacheKey);
        if (StringUtils.isBlank((CharSequence)code)) {
            return "\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f";
        }
        if (!StringUtils.equals((CharSequence)code, (CharSequence)verifyCode)) {
            return "\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e";
        }
        return null;
    }
}

