/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.provider;

import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.cloudt.context.util.CollectionUtil;
import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.system.provider.SysFlowRoleService;
import com.elitesland.yst.system.provider.dto.SysFlowRoleDTO;
import com.elitesland.yst.system.provider.dto.SysUserFlowRoleDTO;
import com.elitesland.yst.system.service.ISysFlowRoleService;
import com.elitesland.yst.system.service.ISysUserFlowRoleService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@DubboService
@UnicomTag(value="GENERAL")
public class SysFlowRoleRpcServiceImpl
implements SysFlowRoleService {
    private static final Logger log = LoggerFactory.getLogger(SysFlowRoleRpcServiceImpl.class);
    private static final int PER_MAX = 50;
    @Autowired
    private ISysFlowRoleService flowRoleService;
    @Autowired
    private ISysUserFlowRoleService userFlowRoleService;

    public ApiResult<SysFlowRoleDTO> get(Long id) {
        if (id == null) {
            return ApiResult.fail((String)"ID\u4e3a\u7a7a");
        }
        List flowRows = this.flowRoleService.getById(List.of(id));
        if (flowRows.isEmpty()) {
            return ApiResult.fail((String)"\u672a\u67e5\u8be2\u5230\u6570\u636e");
        }
        return ApiResult.ok((Object)((SysFlowRoleDTO)flowRows.get(0)));
    }

    public ApiResult<List<SysFlowRoleDTO>> get(List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return ApiResult.fail((String)"ID\u4e3a\u7a7a");
        }
        ArrayList recordList = new ArrayList(ids.size());
        CollectionUtil.split(ids, (int)50, sub -> {
            List temp = this.flowRoleService.getById(sub);
            if (!temp.isEmpty()) {
                recordList.addAll(temp);
            }
        });
        return ApiResult.ok(recordList);
    }

    public ApiResult<SysFlowRoleDTO> getByCode(String code) {
        if (!StringUtils.hasText((String)code)) {
            return ApiResult.fail((String)"\u7f16\u7801\u4e3a\u7a7a");
        }
        List flowRows = this.flowRoleService.getByCode(List.of(code));
        if (flowRows.isEmpty()) {
            return ApiResult.fail((String)"\u672a\u67e5\u8be2\u5230\u6570\u636e");
        }
        return ApiResult.ok((Object)((SysFlowRoleDTO)flowRows.get(0)));
    }

    public ApiResult<List<SysFlowRoleDTO>> getByCode(List<String> codes) {
        if (codes == null || codes.isEmpty()) {
            return ApiResult.fail((String)"\u7f16\u7801\u4e3a\u7a7a");
        }
        ArrayList recordList = new ArrayList(codes.size());
        CollectionUtil.split(codes, (int)50, sub -> {
            List temp = this.flowRoleService.getByCode(sub);
            if (!temp.isEmpty()) {
                recordList.addAll(temp);
            }
        });
        return ApiResult.ok(recordList);
    }

    public ApiResult<List<SysFlowRoleDTO>> getByUserId(Long userId) {
        if (userId == null) {
            return ApiResult.fail((String)"\u7528\u6237ID\u4e3a\u7a7a");
        }
        Map res = this.userFlowRoleService.queryIdsByUserId(List.of(userId));
        if (res.isEmpty()) {
            return ApiResult.ok(Collections.emptyList());
        }
        List roleIds = (List)res.get(userId);
        List roles = this.flowRoleService.getById(roleIds);
        if (roles == null) {
            roles = Collections.emptyList();
        }
        roles = roles.stream().filter(t -> Boolean.TRUE.equals(t.getEnabled())).collect(Collectors.toList());
        return ApiResult.ok(roles);
    }

    public ApiResult<List<SysUserFlowRoleDTO>> getByUserId(List<Long> userIds) {
        if (userIds == null || userIds.isEmpty()) {
            return ApiResult.fail((String)"\u7528\u6237ID\u4e3a\u7a7a");
        }
        HashMap<Long, List<Long>> userRoleMap = new HashMap<Long, List<Long>>(userIds.size());
        CollectionUtil.split(userIds, (int)50, sub -> {
            Map temp = this.userFlowRoleService.queryIdsByUserId(sub);
            userRoleMap.putAll(temp);
        });
        if (userRoleMap.isEmpty()) {
            return this.returnEmptyUserRole(userIds);
        }
        List<Long> roleIds = userRoleMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        if (roleIds.isEmpty()) {
            return this.returnEmptyUserRole(userIds);
        }
        Map<Long, SysFlowRoleDTO> roleMap = ((List)this.get(roleIds).getData()).stream().collect(Collectors.toMap(SysFlowRoleDTO::getId, t -> t, (t1, t2) -> t1));
        return this.returnUserRole(userIds, userRoleMap, roleMap);
    }

    private ApiResult<List<SysUserFlowRoleDTO>> returnEmptyUserRole(List<Long> userIds) {
        List res = userIds.stream().map(t -> {
            SysUserFlowRoleDTO dto = new SysUserFlowRoleDTO();
            dto.setUserId(t);
            dto.setFlowRoleDTOS(Collections.emptyList());
            return dto;
        }).collect(Collectors.toList());
        return ApiResult.ok(res);
    }

    private ApiResult<List<SysUserFlowRoleDTO>> returnUserRole(List<Long> userIds, Map<Long, List<Long>> userRoleMap, Map<Long, SysFlowRoleDTO> roleMap) {
        List res = userIds.stream().map(t -> {
            SysUserFlowRoleDTO dto = new SysUserFlowRoleDTO();
            dto.setUserId(t);
            List roleIds = (List)userRoleMap.get(t);
            if (roleIds == null || roleIds.isEmpty()) {
                dto.setFlowRoleDTOS(Collections.emptyList());
            } else {
                List roles = roleIds.stream().filter(roleMap::containsKey).map(roleMap::get).filter(role -> Boolean.TRUE.equals(role.getEnabled())).collect(Collectors.toList());
                dto.setFlowRoleDTOS(roles);
            }
            return dto;
        }).collect(Collectors.toList());
        return ApiResult.ok(res);
    }
}

