/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.provider;

import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.system.param.SysPermissionNewParam;
import com.elitesland.yst.system.param.SysPermissionUpdateParam;
import com.elitesland.yst.system.service.ISysPermissionService;
import com.elitesland.yst.system.service.SysPermissionService;
import com.elitesland.yst.system.vo.AntTreeNode;
import com.elitesland.yst.system.vo.SysPermissionVO;
import com.elitesland.yst.system.vo.SysPermissionWithRoleVO;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;

@DubboService(version="${provider.service.version}")
@UnicomTag(value="GENERAL")
public class SysPermissionServiceFacade
implements SysPermissionService {
    private ISysPermissionService sysPermissionService;

    @Autowired
    public void setSysPermissionService(ISysPermissionService sysPermissionService) {
        this.sysPermissionService = sysPermissionService;
    }

    public Long createMenu(SysPermissionNewParam permission) {
        return this.sysPermissionService.createMenu(permission);
    }

    public Long createAction(SysPermissionNewParam permission) throws BusinessException {
        return this.sysPermissionService.createAction(permission);
    }

    public void update(SysPermissionUpdateParam perm) {
        this.sysPermissionService.update(perm);
    }

    public List<AntTreeNode> listAllMenuTree() {
        return this.sysPermissionService.listAllMenuTree();
    }

    public List<AntTreeNode> listAllMenuWithActionTree(String terminalCode) {
        return this.sysPermissionService.listAllMenuWithActionTree(terminalCode);
    }

    public List<AntTreeNode> listAllMenuWithActionTree(Long permId) {
        return this.sysPermissionService.listAllMenuWithActionTree(permId);
    }

    public Set<SysPermissionVO> listAllPermissionsByIds(List<Long> ids) {
        return this.sysPermissionService.listAllPermissionsByIds(ids);
    }

    public List<AntTreeNode> listPermTreeByIds(List<Long> ids) {
        return this.sysPermissionService.listPermTreeByIds(ids);
    }

    public Optional<SysPermissionVO> getById(Long id) {
        return this.sysPermissionService.getById(id);
    }

    public List<SysPermissionVO> listActionsByMenuId(Long id) {
        return (List)ObjectUtil.defaultIfNull((Object)((List)this.sysPermissionService.listActionsByMenuId(id).getData()), Collections.emptyList());
    }

    public List<SysPermissionVO> findAllByPermType(Integer permType) {
        return this.sysPermissionService.findAllByPermType(permType);
    }

    public List<SysPermissionVO> findAll() {
        return this.sysPermissionService.findAll();
    }

    public List<SysPermissionWithRoleVO> listAllPermissionsWithRoles() {
        return Collections.emptyList();
    }

    public boolean refreshPermissionRolesCache() {
        return false;
    }
}

