/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.provider;

import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.supportdomain.provider.org.param.OrgUserIdBuParam;
import com.elitesland.yst.supportdomain.provider.org.service.OrgUserEmpBuRpcService;
import com.elitesland.yst.system.param.SysUserIdFlowRoleRpcParam;
import com.elitesland.yst.system.service.ISysUserFlowRoleService;
import com.elitesland.yst.system.service.SysUserFlowRoleRpcService;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DubboService
@UnicomTag(value="GENERAL")
public class SysUserFlowRoleRpcServiceImpl
implements SysUserFlowRoleRpcService {
    private static final Logger log = LoggerFactory.getLogger(SysUserFlowRoleRpcServiceImpl.class);
    private final ISysUserFlowRoleService sysUserFlowRoleService;
    @DubboReference
    private OrgUserEmpBuRpcService orgUserEmpBuRpcService;

    public List<Long> findUserIdsByFlowRoles(SysUserIdFlowRoleRpcParam param) {
        List buIds;
        List userIds = this.sysUserFlowRoleService.findUserIdsByFlowRoleCodes(param.getFlowRoleCodes());
        if (CollectionUtils.isEmpty((Collection)userIds)) {
            return Collections.emptyList();
        }
        List ouIds = param.getOuIds() == null ? null : param.getOuIds().stream().distinct().filter(Objects::nonNull).collect(Collectors.toList());
        List list = buIds = param.getBuIds() == null ? null : param.getBuIds().stream().distinct().filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(ouIds) || CollectionUtils.isNotEmpty(buIds)) {
            try {
                List ouUserIds;
                OrgUserIdBuParam userIdBuParam = OrgUserIdBuParam.builder().ouIds(ouIds).buIds(buIds).build();
                ApiResult supportRpcResult = this.orgUserEmpBuRpcService.findUserIdsByParam(userIdBuParam);
                if (supportRpcResult.isSuccess()) {
                    ouUserIds = (List)supportRpcResult.getData();
                    if (CollectionUtils.isEmpty((Collection)ouUserIds)) {
                        return Collections.emptyList();
                    }
                } else {
                    throw new BusinessException(ApiCode.CLOUD_SERVICE_EXCEPTION, "\u672a\u83b7\u53d6\u5230\u516c\u53f8\u6240\u6709\u5458\u5de5\u4fe1\u606f\uff1a" + supportRpcResult.getMsg());
                }
                userIds.retainAll(ouUserIds);
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u516c\u53f8\u6240\u6709\u5458\u5de5\u4fe1\u606f\uff0c\u5fae\u670d\u52a1\u8c03\u7528\u5f02\u5e38\uff1a", (Throwable)e);
                throw new BusinessException(ApiCode.CLOUD_SERVICE_EXCEPTION, "\u83b7\u53d6\u516c\u53f8\u6240\u6709\u5458\u5de5\u4fe1\u606f\uff0c\u5fae\u670d\u52a1\u8c03\u7528\u5f02\u5e38");
            }
        }
        return userIds;
    }

    public SysUserFlowRoleRpcServiceImpl(ISysUserFlowRoleService sysUserFlowRoleService) {
        this.sysUserFlowRoleService = sysUserFlowRoleService;
    }
}

