/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.provider;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.system.convert.SysUserConvert;
import com.elitesland.yst.system.param.SysPhoneUpdate;
import com.elitesland.yst.system.param.SysUserNewParam;
import com.elitesland.yst.system.provider.SysUserRpcService;
import com.elitesland.yst.system.provider.dto.SysUserRpcDTO;
import com.elitesland.yst.system.provider.param.SysUserRpcDtoParam;
import com.elitesland.yst.system.provider.param.SysUserRpcSaveParam;
import com.elitesland.yst.system.provider.repo.SysUserRpcRepoProc;
import com.elitesland.yst.system.repo.SysUserRepo;
import com.elitesland.yst.system.repo.SysUserRepoProc;
import com.elitesland.yst.system.service.ISysUserService;
import com.elitesland.yst.system.vo.SysUserDTO;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;

@DubboService
@UnicomTag(value="GENERAL")
public class SysUserRpcServiceImpl
implements SysUserRpcService {
    @Autowired
    private SysUserRepo sysUserRepo;
    @Autowired
    private SysUserRepoProc sysUserRepoProc;
    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    private SysUserRpcRepoProc sysUserRpcRepoProc;

    public ApiResult<String> updateUserWechatOpenid(String userName, String openid) {
        return this.sysUserService.updateUserWechatOpenid(userName, openid);
    }

    public List<SysUserRpcDTO> findUserRpcDtoByParam(SysUserRpcDtoParam param) {
        return this.sysUserService.findUserRpcDtoByParam(param);
    }

    public ApiResult<Object> sysUserAccountCreate(SysUserRpcSaveParam param) {
        if (StringUtils.isBlank((CharSequence)param.getUsername())) {
            return ApiResult.fail((ApiCode)ApiCode.CLOUD_SERVICE_EXCEPTION, (Object)"\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)param.getPassword())) {
            return ApiResult.fail((ApiCode)ApiCode.CLOUD_SERVICE_EXCEPTION, (Object)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysUserNewParam newUser = new SysUserNewParam();
        newUser.setUsername(param.getUsername());
        newUser.setFirstName(param.getFirstName());
        newUser.setLastName(param.getLastName());
        newUser.setMobile(param.getMobile());
        newUser.setEmail(param.getEmail());
        newUser.setEnabled(param.getEnabled());
        newUser.setOuId(param.getOuId());
        newUser.setOuCode(param.getOuCode());
        newUser.setOuName(param.getOuName());
        newUser.setRoleIds(param.getRoleIds());
        newUser.setDataRoleIds(param.getDataRoleIds());
        newUser.setFlowRoleIds(param.getFlowRoleIds());
        newUser.setSourceType(CharSequenceUtil.blankToDefault((CharSequence)param.getSourceType(), (String)"oth"));
        newUser.setTerminals(param.getTerminals());
        newUser.setTenantId(param.getTenantId());
        newUser.setUserType(param.getUserType());
        Long userId = this.sysUserService.create(newUser, param.getPassword());
        return ApiResult.ok((Object)userId);
    }

    public ApiResult<Long> getUserIdByUsername(String username) {
        Long userId = this.sysUserService.getUserIdByUsername(username);
        return ApiResult.ok((Object)userId);
    }

    public ApiResult<SysUserDTO> getUserByUsername(String username) {
        SysUserDTO user = this.sysUserService.getUserByUsername(username);
        return ApiResult.ok((Object)user);
    }

    public ApiResult<SysUserDTO> getUserByMobile(String mobile) {
        SysUserDTO user = this.sysUserService.getUserByMobile(mobile);
        return ApiResult.ok((Object)user);
    }

    public ApiResult<SysUserDTO> getUserByEmail(String email) {
        SysUserDTO user = this.sysUserService.getUserByEmail(email);
        return ApiResult.ok((Object)user);
    }

    public ApiResult<SysUserDTO> getUserById(String userId) {
        SysUserDTO user = this.sysUserService.getUserById(Long.valueOf(Long.parseLong(userId)));
        return ApiResult.ok((Object)user);
    }

    public ApiResult<SysUserDTO> getUserByWechatOpenid(String wechatOpenid) {
        SysUserDTO user = this.sysUserService.getUserByWechatOpenid(wechatOpenid);
        return ApiResult.ok((Object)user);
    }

    public ApiResult<SysUserDTO> getUserByAccount(String account) {
        SysUserDTO user = this.sysUserService.getUserByAccount(account);
        return ApiResult.ok((Object)user);
    }

    public SysUserDTO findUserById(Long userId) {
        return this.sysUserRepo.findById(userId).map(SysUserConvert.INSTANCE::doToDto).orElse(null);
    }

    public ApiResult<Long> updateAccountPhone(SysPhoneUpdate updateParam) {
        return this.sysUserService.updateAccountPhone(updateParam);
    }
}

