/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.provider.repo;

import com.elitesland.yst.system.entity.QSysUserDO;
import com.elitesland.yst.system.model.entity.QSysUserRoleDO;
import com.elitesland.yst.system.provider.dto.SysUserRpcDTO;
import com.elitesland.yst.system.provider.param.SysUserRpcDtoParam;
import com.elitesland.yst.utils.AbstractRepoProc;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class SysUserRpcRepoProc
extends AbstractRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QSysUserDO sysUserDO = QSysUserDO.sysUserDO;
    private final QSysUserRoleDO sysUserRoleDO = QSysUserRoleDO.sysUserRoleDO;

    public List<SysUserRpcDTO> findRpcDtoByParam(SysUserRpcDtoParam param) {
        List sourceTypes;
        String likeStr;
        List mobiles;
        List emails;
        List usernames;
        List userIds;
        JPAQuery query = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SysUserRpcDTO.class, (Expression[])new Expression[]{this.sysUserDO.id, this.sysUserDO.username, this.sysUserDO.lastName, this.sysUserDO.firstName, this.sysUserDO.mobile, this.sysUserDO.email, this.sysUserDO.sourceType, this.sysUserDO.enabled, this.sysUserDO.needReset, this.sysUserDO.avatarUrl, this.sysUserDO.avatarCode, this.sysUserDO.wxOpenid})).from((EntityPath)this.sysUserDO);
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (CollectionUtils.isNotEmpty((Collection)param.getUserIds()) && CollectionUtils.isNotEmpty(userIds = this.filterList(param.getUserIds()))) {
            predicates.add(this.sysUserDO.id.in(userIds));
        }
        if (CollectionUtils.isNotEmpty((Collection)param.getUsernames()) && CollectionUtils.isNotEmpty(usernames = this.filterList(param.getUsernames()))) {
            predicates.add(this.sysUserDO.username.in(usernames));
        }
        if (CollectionUtils.isNotEmpty((Collection)param.getEmails()) && CollectionUtils.isNotEmpty(emails = this.filterList(param.getEmails()))) {
            predicates.add(this.sysUserDO.email.in(emails));
        }
        if (CollectionUtils.isNotEmpty((Collection)param.getMobiles()) && CollectionUtils.isNotEmpty(mobiles = this.filterList(param.getMobiles()))) {
            predicates.add(this.sysUserDO.mobile.in(mobiles));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getRepeatMobile())) {
            likeStr = this.buildLikeStr(param.getRepeatMobile());
            predicates.add(this.sysUserDO.mobile.like(likeStr));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getRepeatEmail())) {
            likeStr = this.buildLikeStr(param.getRepeatEmail());
            predicates.add(this.sysUserDO.email.like(likeStr));
        }
        if (CollectionUtils.isNotEmpty((Collection)param.getSourceTypes()) && CollectionUtils.isNotEmpty(sourceTypes = this.filterList(param.getSourceTypes()))) {
            predicates.add(this.sysUserDO.sourceType.in(sourceTypes));
        }
        if (param.getEnabled() != null) {
            predicates.add(this.sysUserDO.enabled.eq(param.getEnabled()));
        }
        if (CollectionUtils.isEmpty(predicates)) {
            return Collections.emptyList();
        }
        query.where(ExpressionUtils.allOf(predicates));
        return query.fetch();
    }

    public List<Long> findUserIdsByRoleIds(List<Long> roleIds) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.sysUserRoleDO.userId).from((EntityPath)this.sysUserRoleDO)).where((Predicate)this.sysUserRoleDO.roleId.in(roleIds))).fetch();
    }

    public SysUserRpcRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

