/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.repo;

import cn.hutool.core.collection.CollUtil;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.core.common.BaseRepoProc;
import com.elitesland.yst.system.model.entity.QSysDataRoleDO;
import com.elitesland.yst.system.model.entity.SysDataRoleDO;
import com.elitesland.yst.system.service.param.SysDataRolePagingParam;
import com.elitesland.yst.system.service.vo.SysDataRoleDetailsVO;
import com.elitesland.yst.system.service.vo.SysDataRolePagingVO;
import com.elitesland.yst.system.service.vo.SysDataRoleSelectVO;
import com.elitesland.yst.system.vo.SysDataRoleVO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository
public class SysDataRoleRepoProc
extends BaseRepoProc<SysDataRoleDO> {
    private static final QSysDataRoleDO QDO = QSysDataRoleDO.sysDataRoleDO;

    public SysDataRoleRepoProc() {
        super((EntityPathBase)QDO);
    }

    public PagingVO<SysDataRolePagingVO> findPaging(SysDataRolePagingParam param) {
        JPAQuery query = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SysDataRolePagingVO.class, (Expression[])new Expression[]{SysDataRoleRepoProc.QDO.id, SysDataRoleRepoProc.QDO.code, SysDataRoleRepoProc.QDO.name, SysDataRoleRepoProc.QDO.enabled, SysDataRoleRepoProc.QDO.remark})).from((EntityPath)QDO);
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (StringUtils.isNotBlank((CharSequence)param.getCode())) {
            predicates.add(SysDataRoleRepoProc.QDO.code.like("%" + param.getCode() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getName())) {
            predicates.add(SysDataRoleRepoProc.QDO.name.like("%" + param.getName() + "%"));
        }
        if (param.getEnabled() != null) {
            predicates.add(SysDataRoleRepoProc.QDO.enabled.eq(param.getEnabled()));
        }
        if (CollectionUtils.isNotEmpty(predicates)) {
            query.where(ExpressionUtils.allOf(predicates));
        }
        param.fillOrders(query, (EntityPathBase)QDO);
        param.setPaging(query);
        return PagingVO.builder().total(Long.valueOf(query.fetchCount())).records(query.fetch()).build();
    }

    public SysDataRoleDetailsVO findDetailsById(Long id) {
        return (SysDataRoleDetailsVO)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SysDataRoleDetailsVO.class, (Expression[])new Expression[]{SysDataRoleRepoProc.QDO.id, SysDataRoleRepoProc.QDO.code, SysDataRoleRepoProc.QDO.name, SysDataRoleRepoProc.QDO.enabled, SysDataRoleRepoProc.QDO.advancedEnable, SysDataRoleRepoProc.QDO.businessEnable, SysDataRoleRepoProc.QDO.remark})).from((EntityPath)QDO)).where((Predicate)SysDataRoleRepoProc.QDO.id.eq((Object)id))).fetchOne();
    }

    public List<SysDataRoleSelectVO> findDataRoleSelectAll() {
        return ((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SysDataRoleSelectVO.class, (Expression[])new Expression[]{SysDataRoleRepoProc.QDO.id, SysDataRoleRepoProc.QDO.code, SysDataRoleRepoProc.QDO.name, SysDataRoleRepoProc.QDO.enabled})).from((EntityPath)QDO)).fetch();
    }

    public void switchEnableByIds(List<Long> ids, boolean enable) {
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)SysDataRoleRepoProc.QDO.enabled, (Object)enable).where(new Predicate[]{SysDataRoleRepoProc.QDO.id.in(ids)}).execute();
    }

    public SysDataRoleVO findDataRoleByCode(String roleCode) {
        return (SysDataRoleVO)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SysDataRoleVO.class, (Expression[])new Expression[]{SysDataRoleRepoProc.QDO.code, SysDataRoleRepoProc.QDO.name})).from((EntityPath)QDO)).where((Predicate)SysDataRoleRepoProc.QDO.code.eq((Object)roleCode))).fetchOne();
    }

    public Map<String, Long> getIdByName(Set<String> names) {
        List res = ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{SysDataRoleRepoProc.QDO.id, SysDataRoleRepoProc.QDO.name}).from((EntityPath)QDO)).where((Predicate)SysDataRoleRepoProc.QDO.name.in(names).and((Predicate)SysDataRoleRepoProc.QDO.enabled.eq(Boolean.valueOf(true))).and((Predicate)SysDataRoleRepoProc.QDO.deleteFlag.eq((Object)0)))).fetch();
        if (CollUtil.isEmpty((Collection)res)) {
            return Collections.emptyMap();
        }
        return res.stream().collect(Collectors.toMap(t -> (String)t.get((Expression)SysDataRoleRepoProc.QDO.name), t -> (Long)t.get(SysDataRoleRepoProc.QDO.id), (t1, t2) -> t1));
    }

    public Map<String, Long> getIdByCode(Set<String> codes) {
        List res = ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{SysDataRoleRepoProc.QDO.id, SysDataRoleRepoProc.QDO.code}).from((EntityPath)QDO)).where((Predicate)SysDataRoleRepoProc.QDO.code.in(codes).and((Predicate)SysDataRoleRepoProc.QDO.enabled.eq(Boolean.valueOf(true))).and((Predicate)SysDataRoleRepoProc.QDO.deleteFlag.eq((Object)0)))).fetch();
        if (CollUtil.isEmpty((Collection)res)) {
            return Collections.emptyMap();
        }
        return res.stream().collect(Collectors.toMap(t -> (String)t.get((Expression)SysDataRoleRepoProc.QDO.code), t -> (Long)t.get(SysDataRoleRepoProc.QDO.id), (t1, t2) -> t1));
    }

    public Long getIdByCode(String code) {
        return (Long)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(SysDataRoleRepoProc.QDO.id).from((EntityPath)QDO)).where((Predicate)SysDataRoleRepoProc.QDO.code.eq((Object)code))).limit(1L)).fetchOne();
    }
}

