/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.repo;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.system.model.entity.QSysFlowRoleDO;
import com.elitesland.yst.system.provider.dto.SysFlowRoleDTO;
import com.elitesland.yst.system.service.param.SysFlowRolePagingParam;
import com.elitesland.yst.system.service.vo.SysFlowRoleDetailsVO;
import com.elitesland.yst.system.service.vo.SysFlowRolePagingVO;
import com.elitesland.yst.system.service.vo.SysFlowRoleSelectVO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class SysFlowRoleRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QSysFlowRoleDO sysFlowRoleDO = QSysFlowRoleDO.sysFlowRoleDO;

    public PagingVO<SysFlowRolePagingVO> findPaging(SysFlowRolePagingParam param) {
        JPAQuery query = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SysFlowRolePagingVO.class, (Expression[])new Expression[]{this.sysFlowRoleDO.id, this.sysFlowRoleDO.code, this.sysFlowRoleDO.name, this.sysFlowRoleDO.enabled})).from((EntityPath)this.sysFlowRoleDO);
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (StringUtils.isNotBlank((String)param.getCode())) {
            predicates.add(this.sysFlowRoleDO.code.like("%" + param.getCode() + "%"));
        }
        if (StringUtils.isNotBlank((String)param.getName())) {
            predicates.add(this.sysFlowRoleDO.name.like("%" + param.getName() + "%"));
        }
        if (param.getEnable() != null) {
            predicates.add(this.sysFlowRoleDO.enabled.eq(param.getEnable()));
        }
        if (CollectionUtils.isNotEmpty(predicates)) {
            query.where(ExpressionUtils.allOf(predicates));
        }
        param.fillOrders(query, (EntityPathBase)this.sysFlowRoleDO);
        param.setPaging(query);
        return PagingVO.builder().total(Long.valueOf(query.fetchCount())).records(query.fetch()).build();
    }

    public SysFlowRoleDetailsVO findDetailsById(Long id) {
        return (SysFlowRoleDetailsVO)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SysFlowRoleDetailsVO.class, (Expression[])new Expression[]{this.sysFlowRoleDO.id, this.sysFlowRoleDO.code, this.sysFlowRoleDO.name, this.sysFlowRoleDO.enabled})).from((EntityPath)this.sysFlowRoleDO)).where((Predicate)this.sysFlowRoleDO.id.eq((Object)id))).fetchOne();
    }

    public List<SysFlowRoleDTO> queryById(List<Long> ids) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SysFlowRoleDTO.class, (Expression[])new Expression[]{this.sysFlowRoleDO.id, this.sysFlowRoleDO.code, this.sysFlowRoleDO.name, this.sysFlowRoleDO.enabled, this.sysFlowRoleDO.createTime})).from((EntityPath)this.sysFlowRoleDO)).where((Predicate)this.sysFlowRoleDO.id.in(ids))).fetch();
    }

    public List<SysFlowRoleDTO> queryByCode(List<String> codes) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SysFlowRoleDTO.class, (Expression[])new Expression[]{this.sysFlowRoleDO.id, this.sysFlowRoleDO.code, this.sysFlowRoleDO.name, this.sysFlowRoleDO.enabled, this.sysFlowRoleDO.createTime})).from((EntityPath)this.sysFlowRoleDO)).where((Predicate)this.sysFlowRoleDO.code.in(codes))).fetch();
    }

    public List<SysFlowRoleSelectVO> findSelectVoAll() {
        return ((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SysFlowRoleSelectVO.class, (Expression[])new Expression[]{this.sysFlowRoleDO.id, this.sysFlowRoleDO.code, this.sysFlowRoleDO.name, this.sysFlowRoleDO.enabled})).from((EntityPath)this.sysFlowRoleDO)).fetch();
    }

    public void updateStatusByIds(boolean enable, List<Long> ids) {
        this.jpaQueryFactory.update((EntityPath)this.sysFlowRoleDO).set((Path)this.sysFlowRoleDO.enabled, (Object)enable).where(new Predicate[]{this.sysFlowRoleDO.id.in(ids)}).execute();
    }

    public Map<String, Long> getIdByName(Set<String> names) {
        List res = ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{this.sysFlowRoleDO.id, this.sysFlowRoleDO.name}).from((EntityPath)this.sysFlowRoleDO)).where((Predicate)this.sysFlowRoleDO.name.in(names).and((Predicate)this.sysFlowRoleDO.enabled.eq(Boolean.valueOf(true))).and((Predicate)this.sysFlowRoleDO.deleteFlag.eq((Object)0)))).fetch();
        if (CollUtil.isEmpty((Collection)res)) {
            return Collections.emptyMap();
        }
        return res.stream().collect(Collectors.toMap(t -> (String)t.get((Expression)this.sysFlowRoleDO.name), t -> (Long)t.get(this.sysFlowRoleDO.id), (t1, t2) -> t1));
    }

    public Map<String, Long> getIdByCode(Set<String> codes) {
        List res = ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{this.sysFlowRoleDO.id, this.sysFlowRoleDO.code}).from((EntityPath)this.sysFlowRoleDO)).where((Predicate)this.sysFlowRoleDO.code.in(codes).and((Predicate)this.sysFlowRoleDO.enabled.eq(Boolean.valueOf(true))).and((Predicate)this.sysFlowRoleDO.deleteFlag.eq((Object)0)))).fetch();
        if (CollUtil.isEmpty((Collection)res)) {
            return Collections.emptyMap();
        }
        return res.stream().collect(Collectors.toMap(t -> (String)t.get((Expression)this.sysFlowRoleDO.code), t -> (Long)t.get(this.sysFlowRoleDO.id), (t1, t2) -> t1));
    }

    public SysFlowRoleRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

