/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.repo;

import cn.hutool.core.collection.CollUtil;
import com.elitesland.yst.core.annotation.TenantTransaction;
import com.elitesland.yst.core.annotation.common.TenantIsolateType;
import com.elitesland.yst.core.common.BaseRepoProc;
import com.elitesland.yst.core.security.common.SysPermTypeEnum;
import com.elitesland.yst.system.model.entity.QSysPermissionDO;
import com.elitesland.yst.system.model.entity.QSysRoleDO;
import com.elitesland.yst.system.model.entity.QSysRolePermissionDO;
import com.elitesland.yst.system.model.entity.SysPermissionDO;
import com.elitesland.yst.system.vo.AntTreeNode;
import com.elitesland.yst.system.vo.SysPermissionRoleVO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository
@TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
public class SysPermissionRepoProc
extends BaseRepoProc<SysPermissionDO> {
    private static final QSysPermissionDO sysPermissionDO = QSysPermissionDO.sysPermissionDO;

    public SysPermissionRepoProc() {
        super((EntityPathBase)sysPermissionDO);
    }

    public JPAQuery<SysPermissionRoleVO> select() {
        QSysRoleDO sysRoleDO = QSysRoleDO.sysRoleDO;
        QSysRolePermissionDO sysRolePermissionDO = QSysRolePermissionDO.sysRolePermissionDO;
        BooleanExpression predicate = sysPermissionDO.isNotNull().or((Predicate)sysPermissionDO.isNull()).and((Predicate)sysRoleDO.isNotNull().or((Predicate)sysRoleDO.isNull())).and((Predicate)sysRolePermissionDO.isNotNull().or((Predicate)sysRolePermissionDO.isNull()));
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SysPermissionRoleVO.class, (Expression[])new Expression[]{SysPermissionRepoProc.sysPermissionDO.id.as("id"), SysPermissionRepoProc.sysPermissionDO.pattern.as("pattern"), SysPermissionRepoProc.sysPermissionDO.httpMethod.as("httpMethod"), SysPermissionRepoProc.sysPermissionDO.terminalCode.as("terminalCode"), SysPermissionRepoProc.sysPermissionDO.isQuick.as("isQuick"), sysRoleDO.code.as("roleCode")})).from((EntityPath)sysPermissionDO)).leftJoin((EntityPath)sysRolePermissionDO)).on((Predicate)SysPermissionRepoProc.sysPermissionDO.id.eq(sysRolePermissionDO.permissionId))).leftJoin((EntityPath)sysRoleDO)).on((Predicate)sysRoleDO.id.eq(sysRolePermissionDO.roleId));
        jpaQuery.where(new Predicate[]{predicate, SysPermissionRepoProc.sysPermissionDO.deleteFlag.eq((Object)0).or((Predicate)SysPermissionRepoProc.sysPermissionDO.deleteFlag.isNull())});
        jpaQuery.where(new Predicate[]{predicate, sysRoleDO.deleteFlag.eq((Object)0).or((Predicate)sysRoleDO.deleteFlag.isNull())});
        jpaQuery.where(new Predicate[]{predicate, sysRolePermissionDO.deleteFlag.eq((Object)0).or((Predicate)sysRolePermissionDO.deleteFlag.isNull())});
        return jpaQuery;
    }

    public List<AntTreeNode> findTreeNodes(Integer permType, String pathLike) {
        JPAQuery query = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(AntTreeNode.class, (Expression[])new Expression[]{SysPermissionRepoProc.sysPermissionDO.id.as("key"), SysPermissionRepoProc.sysPermissionDO.code, SysPermissionRepoProc.sysPermissionDO.name.as("title"), SysPermissionRepoProc.sysPermissionDO.permLevel.as("level"), SysPermissionRepoProc.sysPermissionDO.parentId.as("parentKey"), SysPermissionRepoProc.sysPermissionDO.sortNo, SysPermissionRepoProc.sysPermissionDO.terminalCode, SysPermissionRepoProc.sysPermissionDO.isQuick, SysPermissionRepoProc.sysPermissionDO.icon})).from((EntityPath)sysPermissionDO);
        if (permType != null) {
            query.where((Predicate)SysPermissionRepoProc.sysPermissionDO.permType.eq((Object)permType));
        }
        if (StringUtils.isNotBlank((CharSequence)pathLike)) {
            query.where((Predicate)SysPermissionRepoProc.sysPermissionDO.path.like(pathLike));
        }
        return query.fetch();
    }

    public List<SysPermissionDO> queryByParent(Long parentId) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)sysPermissionDO).from((EntityPath)sysPermissionDO)).where((Predicate)SysPermissionRepoProc.sysPermissionDO.parentId.eq((Object)parentId))).fetch();
    }

    public List<SysPermissionDO> selectTerminalCode(String terminalCode) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)sysPermissionDO).from((EntityPath)sysPermissionDO)).where((Predicate)SysPermissionRepoProc.sysPermissionDO.terminalCode.eq((Object)terminalCode))).fetch();
    }

    public List<SysPermissionDO> queryAll() {
        return this.all();
    }

    public List<SysPermissionDO> queryByIds(Set<Long> ids, SysPermTypeEnum type) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (CollUtil.isNotEmpty(ids)) {
            predicates.add(SysPermissionRepoProc.sysPermissionDO.id.in(ids));
        }
        if (type != null) {
            predicates.add(SysPermissionRepoProc.sysPermissionDO.permType.eq((Object)type.getValue()));
        }
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)sysPermissionDO).from((EntityPath)sysPermissionDO)).where(ExpressionUtils.allOf(predicates))).fetch();
    }

    public Set<Long> queryParentId(Set<Long> ids, SysPermTypeEnum type) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (CollUtil.isNotEmpty(ids)) {
            predicates.add(SysPermissionRepoProc.sysPermissionDO.id.in(ids));
        }
        if (type != null) {
            predicates.add(SysPermissionRepoProc.sysPermissionDO.permType.eq((Object)type.getValue()));
        }
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(SysPermissionRepoProc.sysPermissionDO.parentId).from((EntityPath)sysPermissionDO)).where(ExpressionUtils.allOf(predicates))).fetch().stream().collect(Collectors.toSet());
    }
}

