/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.repo;

import com.elitesland.yst.core.common.BaseRepoProc;
import com.elitesland.yst.system.model.entity.QSysRolePermissionDO;
import com.elitesland.yst.system.model.entity.SysRolePermissionDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class SysRolePermissionRepoProc
extends BaseRepoProc<SysRolePermissionDO> {
    private static final QSysRolePermissionDO QDO = QSysRolePermissionDO.sysRolePermissionDO;

    public SysRolePermissionRepoProc() {
        super((EntityPathBase)QDO);
    }

    public Map<Long, Set<Long>> queryRoleWithPermission(Set<Long> roleIds) {
        HashSet<BooleanExpression> predicates = new HashSet<BooleanExpression>(4);
        if (!CollectionUtils.isEmpty(roleIds)) {
            predicates.add(SysRolePermissionRepoProc.QDO.roleId.in(roleIds));
        }
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{SysRolePermissionRepoProc.QDO.roleId, SysRolePermissionRepoProc.QDO.permissionId}).from((EntityPath)QDO)).where(ExpressionUtils.allOf(predicates))).fetch().stream().collect(Collectors.groupingBy(t -> (Long)t.get(SysRolePermissionRepoProc.QDO.roleId), Collectors.collectingAndThen(Collectors.toList(), t -> t.stream().map(tt -> (Long)tt.get(SysRolePermissionRepoProc.QDO.permissionId)).collect(Collectors.toSet()))));
    }

    public Map<Long, Set<Long>> queryPermissionWithRole(Set<Long> permissionIds) {
        HashSet<BooleanExpression> predicates = new HashSet<BooleanExpression>(4);
        if (!CollectionUtils.isEmpty(permissionIds)) {
            predicates.add(SysRolePermissionRepoProc.QDO.permissionId.in(permissionIds));
        }
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{SysRolePermissionRepoProc.QDO.roleId, SysRolePermissionRepoProc.QDO.permissionId}).from((EntityPath)QDO)).where(ExpressionUtils.allOf(predicates))).fetch().stream().collect(Collectors.groupingBy(t -> (Long)t.get(SysRolePermissionRepoProc.QDO.permissionId), Collectors.collectingAndThen(Collectors.toList(), t -> t.stream().map(tt -> (Long)tt.get(SysRolePermissionRepoProc.QDO.roleId)).collect(Collectors.toSet()))));
    }

    public List<Long> queryPermissionIdByRoleId(Long roleId) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(SysRolePermissionRepoProc.QDO.permissionId).from((EntityPath)QDO)).where((Predicate)SysRolePermissionRepoProc.QDO.roleId.eq((Object)roleId))).fetch();
    }

    public void deleteByRoleIdAndPermissionId(Long roleId, Set<Long> permissionIds) {
        this.jpaQueryFactory.delete((EntityPath)QDO).where(new Predicate[]{SysRolePermissionRepoProc.QDO.roleId.eq((Object)roleId).and((Predicate)SysRolePermissionRepoProc.QDO.permissionId.in(permissionIds))}).execute();
    }
}

