/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.repo;

import cn.hutool.core.collection.CollUtil;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.core.common.BaseRepoProc;
import com.elitesland.yst.system.model.bo.SysRoleBO;
import com.elitesland.yst.system.model.entity.QSysRoleDO;
import com.elitesland.yst.system.model.entity.SysRoleDO;
import com.elitesland.yst.system.param.SysRoleQueryParam;
import com.elitesland.yst.system.service.vo.SysRolePagingVO;
import com.elitesland.yst.system.vo.SysRoleVO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository
public class SysRoleRepoProc
extends BaseRepoProc<SysRoleDO> {
    private static final QSysRoleDO Q_SYS_ROLE_DO = QSysRoleDO.sysRoleDO;

    public SysRoleRepoProc() {
        super((EntityPathBase)Q_SYS_ROLE_DO);
    }

    public PagingVO<SysRolePagingVO> sysRolePagingSearch(SysRoleQueryParam param) {
        JPAQuery query = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SysRolePagingVO.class, (Expression[])new Expression[]{SysRoleRepoProc.Q_SYS_ROLE_DO.id, SysRoleRepoProc.Q_SYS_ROLE_DO.code, SysRoleRepoProc.Q_SYS_ROLE_DO.name, SysRoleRepoProc.Q_SYS_ROLE_DO.enabled})).from((EntityPath)Q_SYS_ROLE_DO);
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (StringUtils.isNotBlank((CharSequence)param.getCode())) {
            predicates.add(SysRoleRepoProc.Q_SYS_ROLE_DO.code.like("%" + param.getCode() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getName())) {
            predicates.add(SysRoleRepoProc.Q_SYS_ROLE_DO.name.like("%" + param.getName() + "%"));
        }
        if (param.getEnabled() != null) {
            predicates.add(SysRoleRepoProc.Q_SYS_ROLE_DO.enabled.eq(param.getEnabled()));
        }
        if (CollectionUtils.isNotEmpty(predicates)) {
            query.where(ExpressionUtils.allOf(predicates));
        }
        param.fillOrders(query, (EntityPathBase)Q_SYS_ROLE_DO);
        param.setPaging(query);
        return PagingVO.builder().total(Long.valueOf(query.fetchCount())).records(query.fetch()).build();
    }

    public void switchEnableByIds(List<Long> ids, boolean enable) {
        this.jpaQueryFactory.update((EntityPath)Q_SYS_ROLE_DO).set((Path)SysRoleRepoProc.Q_SYS_ROLE_DO.enabled, (Object)enable).where(new Predicate[]{SysRoleRepoProc.Q_SYS_ROLE_DO.id.in(ids)}).execute();
    }

    public Map<String, Long> getIdByName(Set<String> names) {
        List res = ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{SysRoleRepoProc.Q_SYS_ROLE_DO.id, SysRoleRepoProc.Q_SYS_ROLE_DO.name}).from((EntityPath)Q_SYS_ROLE_DO)).where((Predicate)SysRoleRepoProc.Q_SYS_ROLE_DO.name.in(names).and((Predicate)SysRoleRepoProc.Q_SYS_ROLE_DO.enabled.eq(Boolean.valueOf(true))).and((Predicate)SysRoleRepoProc.Q_SYS_ROLE_DO.deleteFlag.eq((Object)0)))).fetch();
        if (CollUtil.isEmpty((Collection)res)) {
            return Collections.emptyMap();
        }
        return res.stream().collect(Collectors.toMap(t -> (String)t.get((Expression)SysRoleRepoProc.Q_SYS_ROLE_DO.name), t -> (Long)t.get(SysRoleRepoProc.Q_SYS_ROLE_DO.id), (t1, t2) -> t1));
    }

    public Map<String, Long> getIdByCode(Set<String> codes) {
        List res = ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{SysRoleRepoProc.Q_SYS_ROLE_DO.id, SysRoleRepoProc.Q_SYS_ROLE_DO.code}).from((EntityPath)Q_SYS_ROLE_DO)).where((Predicate)SysRoleRepoProc.Q_SYS_ROLE_DO.code.in(codes).and((Predicate)SysRoleRepoProc.Q_SYS_ROLE_DO.enabled.eq(Boolean.valueOf(true))).and((Predicate)SysRoleRepoProc.Q_SYS_ROLE_DO.deleteFlag.eq((Object)0)))).fetch();
        if (CollUtil.isEmpty((Collection)res)) {
            return Collections.emptyMap();
        }
        return res.stream().collect(Collectors.toMap(t -> (String)t.get((Expression)SysRoleRepoProc.Q_SYS_ROLE_DO.code), t -> (Long)t.get(SysRoleRepoProc.Q_SYS_ROLE_DO.id), (t1, t2) -> t1));
    }

    public Long getIdByCode(String code) {
        return (Long)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(SysRoleRepoProc.Q_SYS_ROLE_DO.id).from((EntityPath)Q_SYS_ROLE_DO)).where((Predicate)SysRoleRepoProc.Q_SYS_ROLE_DO.code.eq((Object)code))).limit(1L)).fetchOne();
    }

    public List<SysRoleBO> query(Set<Long> roleIds) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (CollUtil.isNotEmpty(roleIds)) {
            predicates.add(SysRoleRepoProc.Q_SYS_ROLE_DO.id.in(roleIds));
        }
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.fieldsForSysRoleBO()).from((EntityPath)Q_SYS_ROLE_DO)).where(ExpressionUtils.allOf(predicates))).fetch();
    }

    private QBean<SysRoleBO> fieldsForSysRoleBO() {
        return Projections.bean(SysRoleBO.class, (Expression[])new Expression[]{SysRoleRepoProc.Q_SYS_ROLE_DO.id, SysRoleRepoProc.Q_SYS_ROLE_DO.code, SysRoleRepoProc.Q_SYS_ROLE_DO.name, SysRoleRepoProc.Q_SYS_ROLE_DO.enabled});
    }

    private QBean<SysRoleVO> fieldsForSysRoleVO() {
        return Projections.bean(SysRoleVO.class, (Expression[])new Expression[]{SysRoleRepoProc.Q_SYS_ROLE_DO.id, SysRoleRepoProc.Q_SYS_ROLE_DO.code, SysRoleRepoProc.Q_SYS_ROLE_DO.name, SysRoleRepoProc.Q_SYS_ROLE_DO.enabled});
    }

    public JPAQuery<SysRoleVO> select() {
        return (JPAQuery)this.jpaQueryFactory.select(this.fieldsForSysRoleVO()).from((EntityPath)Q_SYS_ROLE_DO);
    }
}

