/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.repo;

import com.elitesland.yst.system.model.entity.QSysFlowRoleDO;
import com.elitesland.yst.system.model.entity.QSysUserFlowRoleDO;
import com.elitesland.yst.system.service.dto.SysUserFlowRoleDTO;
import com.elitesland.yst.utils.AbstractRepoProc;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class SysUserFlowRoleRepoProc
extends AbstractRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QSysUserFlowRoleDO sysUserFlowRoleDO = QSysUserFlowRoleDO.sysUserFlowRoleDO;
    private final QSysFlowRoleDO sysFlowRoleDO = QSysFlowRoleDO.sysFlowRoleDO;

    public List<String> queryRoleCodeByUserId(Long userId) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.sysFlowRoleDO.code).from((EntityPath)this.sysFlowRoleDO)).leftJoin((EntityPath)this.sysUserFlowRoleDO)).on((Predicate)this.sysFlowRoleDO.id.eq(this.sysUserFlowRoleDO.roleId))).where((Predicate)this.sysUserFlowRoleDO.userId.eq((Object)userId))).fetch();
    }

    public List<SysUserFlowRoleDTO> findDataRoleIdsByUserIds(List<Long> userIds) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SysUserFlowRoleDTO.class, (Expression[])new Expression[]{this.sysUserFlowRoleDO.userId, this.sysFlowRoleDO.id.as("flowRoleId"), this.sysFlowRoleDO.code.as("flowRoleCode"), this.sysFlowRoleDO.name.as("flowRoleName")})).from((EntityPath)this.sysUserFlowRoleDO)).innerJoin((EntityPath)this.sysFlowRoleDO)).on((Predicate)this.sysFlowRoleDO.id.eq(this.sysUserFlowRoleDO.roleId))).where((Predicate)this.sysUserFlowRoleDO.userId.in(userIds))).fetch();
    }

    public List<Long> findUserIdsByFlowRoleLike(String flowRoleCodeName) {
        String likeStr = this.buildLikeStr(flowRoleCodeName);
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.sysUserFlowRoleDO.userId).from((EntityPath)this.sysUserFlowRoleDO)).innerJoin((EntityPath)this.sysFlowRoleDO)).on((Predicate)this.sysFlowRoleDO.id.eq(this.sysUserFlowRoleDO.roleId).and((Predicate)this.sysFlowRoleDO.code.like(likeStr).or((Predicate)this.sysFlowRoleDO.name.like(likeStr))))).fetch();
    }

    public List<Long> findUserIdsByFlowRoleCodes(List<String> roleCodes) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.sysUserFlowRoleDO.userId).from((EntityPath)this.sysFlowRoleDO)).innerJoin((EntityPath)this.sysUserFlowRoleDO)).on((Predicate)this.sysUserFlowRoleDO.roleId.eq(this.sysFlowRoleDO.id))).where((Predicate)this.sysFlowRoleDO.code.in(roleCodes).and((Predicate)this.sysFlowRoleDO.enabled.eq(Boolean.valueOf(true))))).fetch();
    }

    public Map<Long, List<Long>> getByUserId(List<Long> userIds) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{this.sysUserFlowRoleDO.roleId, this.sysUserFlowRoleDO.userId}).from((EntityPath)this.sysUserFlowRoleDO)).where((Predicate)this.sysUserFlowRoleDO.userId.in(userIds))).fetch().stream().collect(Collectors.groupingBy(tuple -> (Long)tuple.get(this.sysUserFlowRoleDO.userId), Collectors.collectingAndThen(Collectors.toList(), t -> t.stream().map(tt -> (Long)tt.get(this.sysUserFlowRoleDO.roleId)).collect(Collectors.toList()))));
    }

    public SysUserFlowRoleRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

