/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.repo;

import com.elitesland.cloudt.context.spi.ServiceProviderLoader;
import com.elitesland.yst.common.base.BaseViewModel;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.constant.AccountType;
import com.elitesland.yst.core.common.BaseRepoProc;
import com.elitesland.yst.core.security.util.DataAuthJpaUtil;
import com.elitesland.yst.core.security.util.SecurityUtil;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import com.elitesland.yst.system.component.param.SysUserComponentPagingParam;
import com.elitesland.yst.system.config.SystemProperties;
import com.elitesland.yst.system.entity.QSysUserDO;
import com.elitesland.yst.system.entity.SysUserDO;
import com.elitesland.yst.system.param.SysUserBatchSwitchParam;
import com.elitesland.yst.system.param.SysUserQueryParam;
import com.elitesland.yst.system.service.ISysRoleService;
import com.elitesland.yst.system.service.param.SysUserPagingParam;
import com.elitesland.yst.system.service.vo.SysUserPagingVO;
import com.elitesland.yst.system.service.vo.component.SysUserComponentPagingVO;
import com.elitesland.yst.system.spi.SysUserQuerySpi;
import com.elitesland.yst.system.vo.SysUserDetailsVO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class SysUserRepoProc
extends BaseRepoProc<SysUserDO> {
    private static final Logger log = LogManager.getLogger(SysUserRepoProc.class);
    private static final QSysUserDO SYS_USER = QSysUserDO.sysUserDO;
    @Autowired
    private ISysRoleService sysRoleService;
    @Autowired
    private SystemProperties systemProperties;
    private final AtomicBoolean spiLoaded = new AtomicBoolean(false);
    private SysUserQuerySpi userQuerySpi;

    public SysUserRepoProc() {
        super((EntityPathBase)SYS_USER);
    }

    public PagingVO<SysUserDO> selectSysUser(SysUserQueryParam param) {
        GeneralUserDetails user = SecurityUtil.getUser();
        if (user == null) {
            return PagingVO.builder().total(Long.valueOf(0L)).records(Collections.emptyList()).build();
        }
        SysUserQuerySpi spi = this.getUserQuerySpi();
        JPAQuery query = null;
        if (spi != null) {
            query = spi.selectSysUserForJpaQuery();
        }
        if (query == null) {
            query = (JPAQuery)this.jpaQueryFactory.select((Expression)SYS_USER).from((EntityPath)SYS_USER);
        }
        Predicate predicate = this.where(param);
        if (spi != null) {
            predicate = this.andPredicate(predicate, spi.selectSysUserForPredicate());
        }
        query.where(predicate);
        param.fillOrders(query, (EntityPathBase)SYS_USER);
        param.setPaging(query);
        return PagingVO.builder().total(Long.valueOf(query.fetchCount())).records(query.fetch()).build();
    }

    public PagingVO<SysUserComponentPagingVO> findSysUserComPagingByParam(SysUserComponentPagingParam param) {
        Predicate predicate;
        String likeStr;
        GeneralUserDetails user = SecurityUtil.getUser();
        if (user == null) {
            return PagingVO.builder().total(Long.valueOf(0L)).records(Collections.emptyList()).build();
        }
        SysUserQuerySpi spi = this.getUserQuerySpi();
        JPAQuery query = null;
        if (spi != null) {
            query = spi.findSysUserComPagingByParamForJpaQuery();
        }
        if (query == null) {
            query = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SysUserComponentPagingVO.class, (Expression[])new Expression[]{SysUserRepoProc.SYS_USER.id, SysUserRepoProc.SYS_USER.username, SysUserRepoProc.SYS_USER.lastName, SysUserRepoProc.SYS_USER.firstName, SysUserRepoProc.SYS_USER.mobile, SysUserRepoProc.SYS_USER.email})).from((EntityPath)SYS_USER);
        }
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (StringUtils.isNotBlank((CharSequence)param.getUsername())) {
            likeStr = "%" + param.getUsername() + "%";
            predicates.add(SysUserRepoProc.SYS_USER.username.like(likeStr));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getFirstName())) {
            likeStr = "%" + param.getFirstName() + "%";
            predicates.add(SysUserRepoProc.SYS_USER.firstName.like(likeStr));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getLastName())) {
            likeStr = "%" + param.getLastName() + "%";
            predicates.add(SysUserRepoProc.SYS_USER.lastName.like(likeStr));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getMobile())) {
            likeStr = "%" + param.getMobile() + "%";
            predicates.add(SysUserRepoProc.SYS_USER.mobile.like(likeStr));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getEmail())) {
            likeStr = "%" + param.getEmail() + "%";
            predicates.add(SysUserRepoProc.SYS_USER.email.like(likeStr));
        }
        predicates.add(SysUserRepoProc.SYS_USER.enabled.eq(Boolean.valueOf(true)));
        predicates.add(SysUserRepoProc.SYS_USER.deleteFlag.isNull().or((Predicate)SysUserRepoProc.SYS_USER.deleteFlag.eq((Object)0)));
        if (spi != null && (predicate = spi.findSysUserComPagingByParamForPredicate()) != null) {
            predicates.add(predicate);
        }
        query.where(ExpressionUtils.allOf(predicates));
        param.fillOrders(query, (EntityPathBase)SYS_USER);
        param.setPaging(query);
        return PagingVO.builder().total(Long.valueOf(query.fetchCount())).records(query.fetch()).build();
    }

    public PagingVO<SysUserPagingVO> findPaging(SysUserPagingParam param, List<Long> userIds) {
        Predicate predicate;
        String likeStr;
        GeneralUserDetails user = SecurityUtil.getUser();
        if (user == null) {
            return PagingVO.builder().total(Long.valueOf(0L)).records(Collections.emptyList()).build();
        }
        SysUserQuerySpi spi = this.getUserQuerySpi();
        JPAQuery query = null;
        if (spi != null) {
            query = spi.findPagingForJpaQuery();
        }
        if (query == null) {
            query = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SysUserPagingVO.class, (Expression[])new Expression[]{SysUserRepoProc.SYS_USER.id, SysUserRepoProc.SYS_USER.username, SysUserRepoProc.SYS_USER.lastName, SysUserRepoProc.SYS_USER.firstName, SysUserRepoProc.SYS_USER.mobile, SysUserRepoProc.SYS_USER.email, SysUserRepoProc.SYS_USER.enabled, SysUserRepoProc.SYS_USER.ouId, SysUserRepoProc.SYS_USER.ouCode, SysUserRepoProc.SYS_USER.ouName, SysUserRepoProc.SYS_USER.buId})).from((EntityPath)SYS_USER);
        }
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (StringUtils.isNotBlank((CharSequence)param.getUsername())) {
            likeStr = "%" + param.getUsername() + "%";
            predicates.add(SysUserRepoProc.SYS_USER.username.like(likeStr));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getName())) {
            likeStr = "%" + param.getName() + "%";
            predicates.add(SysUserRepoProc.SYS_USER.firstName.like(likeStr));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getMobile())) {
            likeStr = "%" + param.getMobile() + "%";
            predicates.add(SysUserRepoProc.SYS_USER.mobile.like(likeStr));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getEmail())) {
            likeStr = "%" + param.getEmail() + "%";
            predicates.add(SysUserRepoProc.SYS_USER.email.like(likeStr));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getOuName())) {
            likeStr = "%" + param.getOuName() + "%";
            predicates.add(SysUserRepoProc.SYS_USER.ouName.like(likeStr));
        }
        if (param.getEnabled() != null) {
            predicates.add(SysUserRepoProc.SYS_USER.enabled.eq(param.getEnabled()));
        }
        if (userIds != null) {
            List filterIds = userIds.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
            predicates.add(SysUserRepoProc.SYS_USER.id.in(filterIds));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getUserType())) {
            predicates.add(SysUserRepoProc.SYS_USER.userType.eq((Object)param.getUserType()));
        }
        if (spi != null && (predicate = spi.selectSysUserForPredicate()) != null) {
            predicates.add(predicate);
        }
        if (CollectionUtils.isNotEmpty(predicates)) {
            query.where(ExpressionUtils.allOf(predicates));
        }
        DataAuthJpaUtil.dataAuthJpaFilter((JPAQuery)query, (PathMetadata)QSysUserDO.sysUserDO.getMetadata());
        param.fillOrders(query, (EntityPathBase)SYS_USER);
        param.setPaging(query);
        return PagingVO.builder().total(Long.valueOf(query.fetchCount())).records(query.fetch()).build();
    }

    public Predicate where(SysUserQueryParam param) {
        BooleanExpression predicate = SYS_USER.isNotNull().or((Predicate)SYS_USER.isNull());
        predicate = StringUtils.isBlank((CharSequence)param.getKeyword()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)SysUserRepoProc.SYS_USER.username.like("%" + param.getKeyword() + "%").or((Predicate)SysUserRepoProc.SYS_USER.firstName.like("%" + param.getKeyword() + "%")).or((Predicate)SysUserRepoProc.SYS_USER.lastName.like("%" + param.getKeyword() + "%")).or((Predicate)SysUserRepoProc.SYS_USER.mobile.like("%" + param.getKeyword() + "%")).or((Predicate)SysUserRepoProc.SYS_USER.email.like("%" + param.getKeyword() + "%")));
        predicate = StringUtils.isBlank((CharSequence)param.getUsername()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)SysUserRepoProc.SYS_USER.username.like("%" + param.getUsername() + "%"));
        predicate = StringUtils.isBlank((CharSequence)param.getName()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)SysUserRepoProc.SYS_USER.firstName.like("%" + param.getName() + "%"));
        predicate = StringUtils.isBlank((CharSequence)param.getMobile()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)SysUserRepoProc.SYS_USER.mobile.like("%" + param.getMobile() + "%"));
        predicate = StringUtils.isBlank((CharSequence)param.getEmail()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)SysUserRepoProc.SYS_USER.email.like("%" + param.getEmail() + "%"));
        predicate = ObjectUtils.isEmpty((Object)param.getEnabled()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)SysUserRepoProc.SYS_USER.enabled.eq(param.getEnabled()));
        predicate = ObjectUtils.isEmpty((Object)param.getSourceType()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)SysUserRepoProc.SYS_USER.sourceType.eq((Object)param.getSourceType()));
        Object object = predicate = ObjectUtils.isEmpty((Object)param.getTransFlag()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)SysUserRepoProc.SYS_USER.transFlag.eq((Object)param.getTransFlag()));
        if (CollectionUtils.isNotEmpty((Collection)param.getRoleIds())) {
            Set roles = this.sysRoleService.listByRoleIds(param.getRoleIds());
            Object[] userIds = (Long[])roles.stream().flatMap(r -> r.getUsers().stream().map(BaseViewModel::getId)).toArray(Long[]::new);
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SysUserRepoProc.SYS_USER.id.in(userIds));
        }
        return predicate;
    }

    public List<String> findUsernameByIds(List<Long> ids) {
        return ((JPAQuery)this.jpaQueryFactory.select((Expression)SysUserRepoProc.SYS_USER.username).where((Predicate)SysUserRepoProc.SYS_USER.id.in(ids))).fetch();
    }

    public void updateStatusByIds(SysUserBatchSwitchParam param) {
        this.jpaQueryFactory.update((EntityPath)SYS_USER).set((Path)SysUserRepoProc.SYS_USER.enabled, (Object)param.isEnable()).where(new Predicate[]{SysUserRepoProc.SYS_USER.id.in((Collection)param.getUserIds())}).execute();
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateOpenidByUserName(String openid, String username) {
        this.jpaQueryFactory.update((EntityPath)SYS_USER).set((Path)SysUserRepoProc.SYS_USER.wxOpenid, (Object)openid).where(new Predicate[]{SysUserRepoProc.SYS_USER.username.eq((Object)username)}).execute();
    }

    public SysUserDetailsVO findDetailsById(Long id) {
        return (SysUserDetailsVO)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SysUserDetailsVO.class, (Expression[])new Expression[]{SysUserRepoProc.SYS_USER.id, SysUserRepoProc.SYS_USER.lastName, SysUserRepoProc.SYS_USER.firstName, SysUserRepoProc.SYS_USER.mobile, SysUserRepoProc.SYS_USER.email, SysUserRepoProc.SYS_USER.enabled, SysUserRepoProc.SYS_USER.ouId, SysUserRepoProc.SYS_USER.ouCode, SysUserRepoProc.SYS_USER.ouName, SysUserRepoProc.SYS_USER.buId, SysUserRepoProc.SYS_USER.avatarUrl, SysUserRepoProc.SYS_USER.avatarCode})).from((EntityPath)SYS_USER)).where((Predicate)SysUserRepoProc.SYS_USER.id.eq((Object)id))).fetchOne();
    }

    public Long getIdByMobile(String mobile) {
        return (Long)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)SysUserRepoProc.SYS_USER.id).from((EntityPath)SYS_USER)).where((Predicate)SysUserRepoProc.SYS_USER.mobile.eq((Object)mobile))).limit(1L)).fetchOne();
    }

    public Long getIdByEmail(String email) {
        return (Long)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)SysUserRepoProc.SYS_USER.id).from((EntityPath)SYS_USER)).where((Predicate)SysUserRepoProc.SYS_USER.email.eq((Object)email))).limit(1L)).fetchOne();
    }

    public Long getIdByUsername(String username) {
        return (Long)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)SysUserRepoProc.SYS_USER.id).from((EntityPath)SYS_USER)).where((Predicate)SysUserRepoProc.SYS_USER.username.eq((Object)username))).limit(1L)).fetchOne();
    }

    public boolean existsUsername(String username) {
        return this.exists(username, (Path)SysUserRepoProc.SYS_USER.username);
    }

    public boolean existsUsername(String username, Long excludeId) {
        return this.exists(username, (Path)SysUserRepoProc.SYS_USER.username, excludeId);
    }

    public boolean existsMobile(String mobile) {
        return this.exists(mobile, (Path)SysUserRepoProc.SYS_USER.mobile);
    }

    public boolean existsMobile(String mobile, Long excludeId) {
        return this.exists(mobile, (Path)SysUserRepoProc.SYS_USER.mobile, excludeId);
    }

    public void updateAvatar(Long id, String avatarUrl, String avatarCode) {
        this.jpaQueryFactory.update((EntityPath)SYS_USER).set((Path)SysUserRepoProc.SYS_USER.avatarUrl, (Object)avatarUrl).set((Path)SysUserRepoProc.SYS_USER.avatarCode, (Object)avatarCode).where(new Predicate[]{SysUserRepoProc.SYS_USER.id.eq((Object)id)}).execute();
    }

    public void updatePassword(Long id, String password) {
        this.updateValue(password, (Path)SysUserRepoProc.SYS_USER.password, id);
    }

    public void updateMobile(Long id, String mobile) {
        this.updateValue(mobile, (Path)SysUserRepoProc.SYS_USER.mobile, id);
    }

    public void updateUsername(Long id, String username) {
        this.updateValue(username, (Path)SysUserRepoProc.SYS_USER.username, id);
    }

    public void updateTenantId(Long id, Long tenantId) {
        this.updateValue(tenantId, (Path)SysUserRepoProc.SYS_USER.tenantId, id);
    }

    public List<SysUserDO> queryByAccount(@NonNull String account) {
        if (this.systemProperties.getAccountTypes().isEmpty()) {
            log.error("\u672a\u914d\u7f6e\u8d26\u53f7\u7c7b\u578b");
            return Collections.emptyList();
        }
        List<AccountType> accountTypes = this.systemProperties.getAccountTypes();
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq(accountTypes.contains(AccountType.USERNAME), (SimpleExpression)SysUserRepoProc.SYS_USER.username, (Object)account).andEq(accountTypes.contains(AccountType.MOBILE), (SimpleExpression)SysUserRepoProc.SYS_USER.mobile, (Object)account).andEq(accountTypes.contains(AccountType.EMAIL), (SimpleExpression)SysUserRepoProc.SYS_USER.email, (Object)account).buildOr();
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)SYS_USER).from((EntityPath)SYS_USER)).where(predicate)).fetch();
    }

    public List<SysUserDO> queryByEmail(@NonNull String email) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)SYS_USER).from((EntityPath)SYS_USER)).where((Predicate)SysUserRepoProc.SYS_USER.email.eq((Object)email))).fetch();
    }

    private SysUserQuerySpi getUserQuerySpi() {
        if (this.spiLoaded.compareAndSet(false, true)) {
            this.userQuerySpi = ServiceProviderLoader.loadProviderInstanceOne(SysUserQuerySpi.class).orElse(null);
            if (this.userQuerySpi != null) {
                log.info("\u52a0\u8f7d\u7528\u6237\u67e5\u8be2SPI\uff1a{}", (Object)this.userQuerySpi.getServiceName());
            }
        }
        return this.userQuerySpi;
    }
}

