/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.rest;

import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.core.security.matedata.DataAuthBusinessJpaUtil;
import com.elitesland.yst.core.security.matedata.DataAuthResult;
import com.elitesland.yst.core.security.matedata.MateDatePredicateVo;
import com.elitesland.yst.system.entity.QSysUserDO;
import com.elitesland.yst.system.model.entity.QSysUserRoleDO;
import com.elitesland.yst.system.param.SysBizDataConstraintSaveParam;
import com.elitesland.yst.system.service.SysBizDataConstraintService;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/data/roles"})
@Api(value="\u6570\u636e\u89d2\u8272-\u4e1a\u52a1\u6570\u636e\u6743\u9650", tags={"\u6570\u636e\u89d2\u8272-\u4e1a\u52a1\u6570\u636e\u6743\u9650"})
public class SysBizDataConstraintController {
    private static final Logger log = LoggerFactory.getLogger(SysBizDataConstraintController.class);
    private SysBizDataConstraintService sysBizDataConstraintService;
    @Autowired
    private JPAQueryFactory jpaQueryFactory;

    @Autowired
    public void setSysBizDataConstraintService(SysBizDataConstraintService sysBizDataConstraintService) {
        this.sysBizDataConstraintService = sysBizDataConstraintService;
    }

    @GetMapping(value={"/{roleCode}/constraints"})
    @ApiOperation(value="\u6839\u636e\u6570\u636e\u89d2\u8272\u7f16\u7801\uff0c \u8fd4\u56de\u5bf9\u5e94\u7684\u7ea6\u675f\u96c6\u5408")
    public ApiResult<?> listByRoleCode(@PathVariable String roleCode) {
        return ApiResult.ok((Object)this.sysBizDataConstraintService.listByRoleCode(roleCode));
    }

    @PostMapping(value={"/{roleCode}/constraints"})
    @ApiOperation(value="\u6839\u636e\u6570\u636e\u89d2\u8272\u7f16\u7801\uff0c\u6279\u91cf\u5168\u5220\u5168\u63d2\u4e1a\u52a1\u6570\u636e\u7ea6\u675f")
    public ApiResult<?> saveInBatch(@PathVariable String roleCode, @RequestBody List<SysBizDataConstraintSaveParam> params) {
        Integer count = this.sysBizDataConstraintService.updateInBatch(roleCode, params);
        return ApiResult.ok((Object)count);
    }

    @GetMapping(value={"/dataAuthBusinessTestDemo"})
    @ApiOperation(value="\u6839\u636e\u6570\u636e\u89d2\u8272\u7f16\u7801\uff0c \u8fd4\u56de\u5bf9\u5e94\u7684\u7ea6\u675f\u96c6\u5408")
    public ApiResult<?> dataAuthBusinessTest() {
        try {
            QSysUserDO qSysUserDO = QSysUserDO.sysUserDO;
            QSysUserRoleDO qSysUserRoleDO = QSysUserRoleDO.sysUserRoleDO;
            JPAQuery query = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)qSysUserDO).from((EntityPath)qSysUserDO)).leftJoin((EntityPath)qSysUserRoleDO)).on((Predicate)qSysUserRoleDO.userId.eq((Expression)qSysUserDO.id))).where((Predicate)qSysUserDO.id.in(new Number[]{1, 2, 3}));
            DataAuthBusinessJpaUtil dataAuthBusinessJpaUtil = new DataAuthBusinessJpaUtil();
            dataAuthBusinessJpaUtil.setDataPermissionEnable(true);
            DataAuthResult dataAuthResult = dataAuthBusinessJpaUtil.dataAuthBusinessJpaUtil(query, (EntityPathBase)qSysUserDO, "SYS");
            if (dataAuthResult.isSuccess()) {
                MateDatePredicateVo resultPredicate = (MateDatePredicateVo)dataAuthResult.getData();
                if (resultPredicate != null) {
                    query.where(resultPredicate.getJpaPredicate());
                } else {
                    log.error("\u4e1a\u52a1\u6570\u636e\u6743\u9650resultPredicate==null" + dataAuthResult.getErrorMsg() + dataAuthResult.getMsg());
                }
            } else {
                log.error("\u4e1a\u52a1\u6570\u636e\u6743\u9650\u5931\u8d25:" + dataAuthResult.getErrorMsg());
            }
            List list = query.fetch();
            return ApiResult.ok((Object)list);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResult.fail((String)("\u64cd\u4f5c\u5f02\u5e38:" + e.getMessage()));
        }
    }
}

