/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.rest;

import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.system.service.SysFrontConfigService;
import com.elitesland.yst.system.service.param.SysFrontConfigSaveParam;
import com.elitesland.yst.system.service.vo.SysFrontConfigSimpleVO;
import com.elitesland.yst.system.service.vo.SysFrontConfigVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/front/config"})
@Api(value="\u524d\u7aef\u8868\u5355\u8868\u683c\u52a8\u6001\u914d\u7f6e", tags={"\u524d\u7aef\u8868\u5355\u8868\u683c\u52a8\u6001\u914d\u7f6e"})
public class SysFrontConfigController {
    private final SysFrontConfigService sysFrontConfigService;

    @ApiOperation(value="\u83b7\u53d6\u914d\u7f6e\u57fa\u672c\u4fe1\u606f\u5217\u8868")
    @GetMapping(value={"/list/{roleId}/{permissionId}"})
    public ApiResult<List<SysFrontConfigSimpleVO>> findListByRoleAndPermission(@PathVariable Long roleId, @PathVariable Long permissionId) {
        return ApiResult.ok((Object)this.sysFrontConfigService.findSimpleListByRoleAndPermission(roleId, permissionId));
    }

    @ApiOperation(value="\u6839\u636e\u89d2\u8272\u548c\u914d\u7f6e\u7f16\u53f7\u83b7\u53d6\u914d\u7f6e\u4fe1\u606f")
    @GetMapping(value={"/role/code/{roleId}/{code}"})
    public ApiResult<SysFrontConfigVO> findConfigByCode(@PathVariable Long roleId, @PathVariable String code) {
        return ApiResult.ok((Object)this.sysFrontConfigService.findConfigByRoleIdAndCode(roleId, code));
    }

    @ApiOperation(value="\u6839\u636e\u914d\u7f6e\u7f16\u53f7\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u4eba\u7684\u914d\u7f6e\u4fe1\u606f")
    @GetMapping(value={"/current/{code}"})
    public ApiResult<SysFrontConfigVO> findConfigByCode(@PathVariable String code) {
        return ApiResult.ok((Object)this.sysFrontConfigService.findConfigByCode(code));
    }

    @ApiOperation(value="\u6839\u636e\u914d\u7f6e\u7f16\u53f7\u83b7\u53d6\u914d\u7f6e\u4fe1\u606f")
    @PostMapping(value={"/save"})
    public ApiResult<String> saveConfig(@RequestBody @Valid SysFrontConfigSaveParam param) {
        return ApiResult.ok((Object)this.sysFrontConfigService.save(param).toString());
    }

    @ApiOperation(value="\u6839\u636e\u914d\u7f6eID\u5220\u9664\u914d\u7f6e\u4fe1\u606f")
    @DeleteMapping(value={"/remove/{id}"})
    public ApiResult<Object> removeById(@PathVariable Long id) {
        this.sysFrontConfigService.removeById(id);
        return ApiResult.ok();
    }

    public SysFrontConfigController(SysFrontConfigService sysFrontConfigService) {
        this.sysFrontConfigService = sysFrontConfigService;
    }
}

