/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.rest;

import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.system.param.SysNumberReqParam;
import com.elitesland.yst.system.param.SysNumberRuleQParam;
import com.elitesland.yst.system.service.ISysNumberRuleService;
import com.elitesland.yst.system.vo.SysNumberRuleVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/numbering"})
@Api(value="\u53d1\u53f7\u5668\u89c4\u5219\u7ba1\u7406", tags={"\u53d1\u53f7\u5668API"})
public class SysNumberRuleController {
    private final ISysNumberRuleService iSysNumberRuleService;

    public SysNumberRuleController(ISysNumberRuleService sysNumberRuleService) {
        this.iSysNumberRuleService = sysNumberRuleService;
    }

    @PostMapping(value={"/rules"})
    @ApiOperation(value="\u521b\u5efa\u53d1\u53f7\u5668\u89c4\u5219\uff0c\u6210\u529f\u5219\u8fd4\u56de\u5bf9\u5e94ID")
    public ApiResult<Long> create(@RequestBody @Valid SysNumberRuleVO rule) {
        return this.iSysNumberRuleService.create(rule);
    }

    @PutMapping(value={"/rules"})
    @ApiOperation(value="\u66f4\u65b0\u53d1\u53f7\u5668\u89c4\u5219")
    public ApiResult<Long> update(@RequestBody @Valid SysNumberRuleVO rule) {
        return this.iSysNumberRuleService.update(rule);
    }

    @PostMapping(value={"/q"})
    @ApiOperation(value="\u68c0\u7d22\u53d1\u53f7\u5668\u89c4\u5219")
    public ApiResult<PagingVO<SysNumberRuleVO>> search(@RequestBody SysNumberRuleQParam param) {
        return this.iSysNumberRuleService.search(param);
    }

    @DeleteMapping(value={"/rules/{id}"})
    @ApiOperation(value="\u5220\u9664\u53d1\u53f7\u5668\u89c4\u5219")
    public ApiResult<Boolean> remove(@PathVariable(value="id") Long id) {
        return this.iSysNumberRuleService.removeById(id);
    }

    @PostMapping(value={"/samplecode"})
    @ApiOperation(value="\u751f\u6210\u6837\u4f8b\u53f7\u7801")
    public ApiResult<String> getSampleCode(@RequestBody @Valid SysNumberReqParam param) {
        return this.iSysNumberRuleService.generateSampleCode(param.getRuleId(), param.getRuntimeValue());
    }

    @PostMapping(value={"/code"})
    @ApiOperation(value="\u751f\u6210\u53f7\u7801")
    public ApiResult<String> getCode(@RequestBody SysNumberReqParam param) {
        return this.iSysNumberRuleService.generateCode(param.getRuleId(), param.getRuntimeValue());
    }

    @GetMapping(value={"/rules/{id}"})
    @ApiOperation(value="\u6839\u636e\u89c4\u5219ID\uff0c\u83b7\u53d6\u89c4\u5219\u5bf9\u8c61\uff0c\u5305\u62ec\u89c4\u5219\u660e\u7ec6\u5217\u8868")
    public ApiResult<SysNumberRuleVO> one(@PathVariable(value="id") Long id) {
        return this.iSysNumberRuleService.oneCombined(id);
    }
}

