/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.rest;

import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.system.param.SysPermissionNewParam;
import com.elitesland.yst.system.param.SysPermissionUpdateParam;
import com.elitesland.yst.system.service.ISysPermissionService;
import com.elitesland.yst.system.service.IUserPermissionService;
import com.elitesland.yst.system.service.impl.SysPermissionCacheManager;
import com.elitesland.yst.system.vo.AntTreeNode;
import com.elitesland.yst.system.vo.SysPermissionVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/permissions"})
@Api(value="\u7cfb\u7edf\u6743\u9650\uff0c\u5e94\u7528\u3001\u64cd\u4f5c\u7ba1\u7406", tags={"\u7cfb\u7edf\u6743\u9650\uff0c\u5e94\u7528\u3001\u64cd\u4f5c\u7ba1\u7406"})
public class SysPermissionController {
    private static final Logger log = LoggerFactory.getLogger(SysPermissionController.class);
    private final ISysPermissionService sysPermissionService;
    private final SysPermissionCacheManager sysPermissionCacheManager;
    private final IUserPermissionService userPermissionService;

    @PostMapping(value={"/newmenu"})
    @ApiOperation(value="\u521b\u5efa\u5e94\u7528")
    public ApiResult<Object> createMenu(@RequestBody @Validated SysPermissionNewParam permission) throws BusinessException {
        Long id = this.sysPermissionService.createMenu(permission);
        return ApiResult.ok((Object)id);
    }

    @PostMapping(value={"/newaction"})
    @ApiOperation(value="\u5728\u5e94\u7528\u4e0b\u521b\u5efa\u64cd\u4f5c\uff0c\u6bd4\u5982\u6309\u94ae")
    public ApiResult<Object> createAction(@RequestBody SysPermissionNewParam permission) throws BusinessException {
        Long id = this.sysPermissionService.createAction(permission);
        return ApiResult.ok((Object)id);
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u901a\u8fc7ID\u83b7\u53d6\u5e94\u7528\u6216\u64cd\u4f5c\u660e\u7ec6\u4fe1\u606f")
    public ApiResult<SysPermissionVO> oneById(@PathVariable Long id) {
        return this.sysPermissionService.getById(id).map(ApiResult::ok).orElse(ApiResult.fail((ApiCode)ApiCode.NOT_FOUND));
    }

    @GetMapping(value={"/actionsbymenu/{id}"})
    @ApiOperation(value="\u901a\u8fc7\u5e94\u7528ID\uff0c\u83b7\u53d6\u5176\u4e0b\u5bf9\u5e94\u7684\u64cd\u4f5c\u6e05\u5355")
    public ApiResult<List<SysPermissionVO>> listActionsByMenuId(@PathVariable Long id) {
        return this.sysPermissionService.listActionsByMenuId(id);
    }

    @PutMapping
    @ApiOperation(value="\u66f4\u65b0\u6743\u9650\u4fe1\u606f")
    public ApiResult<Integer> update(@RequestBody SysPermissionUpdateParam perm) {
        this.sysPermissionService.update(perm);
        return ApiResult.ok((Object)1);
    }

    @GetMapping(value={"/menutree/{terminalCode}"})
    @ApiOperation(value="\u83b7\u53d6\u5e94\u7528\u6811")
    public ApiResult<List<AntTreeNode>> getMenuTree(@PathVariable String terminalCode) {
        return this.userPermissionService.currentUserPermissionMenuTree(terminalCode);
    }

    @GetMapping(value={"/menuactiontree/{terminalCode}"})
    @ApiOperation(value="\u83b7\u53d6\u5e94\u7528\u64cd\u4f5c\u6811")
    public ApiResult<Object> getMenuActionTree(@PathVariable String terminalCode) {
        List tree = this.sysPermissionService.listAllMenuWithActionTree(terminalCode);
        return ApiResult.ok((Object)tree);
    }

    @GetMapping(value={"/menuacttree/{permId}/{terminalCode}"})
    @ApiOperation(value="\u83b7\u53d6\u5e94\u7528\u548c\u64cd\u4f5c\u6811")
    public ApiResult<Object> getMenuActionTree(@PathVariable Long permId, @PathVariable String terminalCode) {
        List tree = this.sysPermissionService.listAllMenuWithActionTree(permId);
        List antTreeNodeList = tree.stream().filter(Objects::nonNull).distinct().filter(t -> terminalCode.equals(t.getTerminalCode())).collect(Collectors.toList());
        return ApiResult.ok(antTreeNodeList);
    }

    @GetMapping(value={"/refreshallwithroles"})
    @ApiOperation(value="\u624b\u52a8\u5237\u65b0\u89d2\u8272\u6743\u9650")
    public ApiResult<Object> listAllPermissionsWithRoles() {
        this.sysPermissionCacheManager.refreshCacheOfAllPermissionsWithRoles();
        return ApiResult.ok();
    }

    @DeleteMapping(value={"/menu/remove/{id}"})
    @ApiOperation(value="\u5220\u9664\u6307\u5b9aID\u7684\u5e94\u7528\u6743\u9650")
    public ApiResult<Object> deleteMenuById(@PathVariable Long id) {
        this.sysPermissionService.deleteMenuById(id);
        return ApiResult.ok();
    }

    @DeleteMapping(value={"/action/remove/batch"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u6307\u5b9aID\u7684\u64cd\u4f5c\u6743\u9650")
    public ApiResult<Object> deleteActionByIdBatch(@RequestBody List<Long> ids) {
        this.sysPermissionService.deleteActionByIds(ids);
        return ApiResult.ok();
    }

    public SysPermissionController(ISysPermissionService sysPermissionService, SysPermissionCacheManager sysPermissionCacheManager, IUserPermissionService userPermissionService) {
        this.sysPermissionService = sysPermissionService;
        this.sysPermissionCacheManager = sysPermissionCacheManager;
        this.userPermissionService = userPermissionService;
    }
}

