/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.rest;

import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.system.param.SysRoleNewParam;
import com.elitesland.yst.system.param.SysRoleQueryParam;
import com.elitesland.yst.system.param.SysRoleUpdateParam;
import com.elitesland.yst.system.service.ISysRolePermissionService;
import com.elitesland.yst.system.service.ISysRoleService;
import com.elitesland.yst.system.service.ISysUserService;
import com.elitesland.yst.system.service.param.SysRoleBatchSwitchParam;
import com.elitesland.yst.system.service.vo.SysRolePagingVO;
import com.elitesland.yst.system.vo.SysPermissionVO;
import com.elitesland.yst.system.vo.SysRoleVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/roles"})
@Api(value="\u89d2\u8272\u4fe1\u606f\u7ef4\u62a4", tags={"\u89d2\u8272\u4fe1\u606f\u7ef4\u62a4"})
public class SysRoleController {
    private static final Logger log = LoggerFactory.getLogger(SysRoleController.class);
    private final ISysRoleService sysRoleService;
    private final ISysUserService sysUserService;
    private final ISysRolePermissionService sysRolePermissionService;

    @PostMapping(value={"/q"})
    @ApiOperation(value="\u5e94\u7528\u89d2\u8272\u5206\u9875\u67e5\u8be2")
    @ApiResponses(value={@ApiResponse(code=200, message="\u5904\u7406\u6210\u529f", responseContainer="List", response=SysRolePagingVO.class)})
    public ApiResult<PagingVO<SysRolePagingVO>> sysRolePagingSearch(@RequestBody SysRoleQueryParam param) {
        return ApiResult.ok((Object)this.sysRoleService.sysRolePagingSearch(param));
    }

    @PostMapping
    @ApiOperation(value="\u521b\u5efa\u89d2\u8272\u4fe1\u606f")
    public ApiResult<String> createInBatch(@RequestBody SysRoleNewParam role) {
        Long ret = this.sysRoleService.create(role);
        return ApiResult.ok((Object)ret.toString());
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u901a\u8fc7ID\u83b7\u53d6\u5355\u4e2a\u89d2\u8272\u4fe1\u606f")
    public ApiResult<?> one(@PathVariable Long id) {
        Optional roleOpt = this.sysRoleService.one(id);
        if (roleOpt.isEmpty()) {
            return ApiResult.fail((ApiCode)ApiCode.NOT_FOUND);
        }
        return ApiResult.ok((Object)((SysRoleVO)roleOpt.get()));
    }

    @PutMapping
    @ApiOperation(value="\u66f4\u65b0\u89d2\u8272\u4fe1\u606f")
    public ApiResult<Integer> update(@RequestBody SysRoleUpdateParam role) {
        this.sysRoleService.update(role);
        return ApiResult.ok((Object)1);
    }

    @GetMapping(value={"/all"})
    @ApiOperation(value="\u5217\u51fa\u6240\u6709\u89d2\u8272")
    public ApiResult<List<SysRoleVO>> listAll() {
        List roles = this.sysRoleService.listAllByPermission();
        return ApiResult.ok((Object)roles);
    }

    @GetMapping(value={"/current/{username}"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237\u540d\u8fd4\u56de\u5bf9\u5e94\u7684\u89d2\u8272\u6e05\u5355")
    public ApiResult<Object> listByUsername(@PathVariable String username) {
        Set roles = this.sysUserService.listRolesByUsername(username);
        return ApiResult.ok((Object)roles);
    }

    @PutMapping(value={"/{id}"})
    @ApiOperation(value="\u5207\u6362\u89d2\u8272\u542f\u7528\u72b6\u6001")
    public ApiResult<Boolean> switchUserStatus(@PathVariable Long id) {
        Boolean ret = this.sysRoleService.switchRoleStatus(id);
        return ApiResult.ok((Object)ret);
    }

    @PostMapping(value={"/status/switch/batch"})
    @ApiOperation(value="\u529f\u80fd\u89d2\u8272\u6279\u91cf\u542f\u7528\u7981\u7528")
    public ApiResult<Object> batchSwitchStatus(@RequestBody SysRoleBatchSwitchParam param) {
        this.sysRoleService.batchSwitchEnable(param);
        return ApiResult.ok();
    }

    @GetMapping(value={"/{id}/menuids/{terminalCode}"})
    @ApiOperation(value="\u6839\u636e\u89d2\u8272ID\uff0c\u8fd4\u56de\u6388\u6743\u7684\u5e94\u7528ID\u96c6\u5408")
    public ApiResult<List<String>> listMenuIdsByIdterminalCode(@PathVariable Long id, @PathVariable String terminalCode) {
        return ApiResult.ok((Object)this.sysRoleService.listMenusByIdAndTerminalCode(id, terminalCode));
    }

    @GetMapping(value={"/{id}/actionids"})
    @ApiOperation(value="\u6839\u636e\u89d2\u8272ID\uff0c \u8fd4\u56de\u6388\u6743\u7684\u64cd\u4f5cID\u96c6\u5408")
    public ApiResult<List<String>> listActionIdsById(@PathVariable Long id) {
        return ApiResult.ok((Object)this.sysRoleService.listActionsById(id));
    }

    @GetMapping(value={"/{id}/menus/{menuId}"})
    @ApiOperation(value="\u6839\u636e\u89d2\u8272ID\uff0c\u548c\u5e94\u7528ID\uff0c\u8fd4\u56de\u6388\u6743\u7684\u64cd\u4f5c\u6e05\u5355")
    public ApiResult<Set<SysPermissionVO>> listActionsByMenuOfRole(@PathVariable Long id, @PathVariable Long menuId) {
        return ApiResult.ok((Object)this.sysRolePermissionService.listActionsByMenuIdOfRole(id, menuId));
    }

    @PostMapping(value={"/{id}/menus/{menuId}"})
    @ApiOperation(value="\u6839\u636e\u89d2\u8272ID\uff0c\u548c\u5e94\u7528ID\uff0c\u66f4\u65b0\u6388\u6743\u64cd\u4f5c\u6e05\u5355")
    public ApiResult<Object> updateActionsByMenuOfRole(@PathVariable Long id, @PathVariable Long menuId, @RequestBody Set<Long> permissionIds) {
        this.sysRolePermissionService.saveActionsByRoleAndRole(id, menuId, permissionIds);
        return ApiResult.ok();
    }

    public SysRoleController(ISysRoleService sysRoleService, ISysUserService sysUserService, ISysRolePermissionService sysRolePermissionService) {
        this.sysRoleService = sysRoleService;
        this.sysUserService = sysUserService;
        this.sysRolePermissionService = sysRolePermissionService;
    }
}

