/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.rest;

import com.elitesland.cloudt.context.util.HttpServletUtil;
import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.util.RedisUtils;
import com.elitesland.yst.core.security.common.SysPermTypeEnum;
import com.elitesland.yst.core.security.permission.PermissionActionBO;
import com.elitesland.yst.core.security.util.SecurityUtil;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import com.elitesland.yst.supportdomain.provider.org.service.OrgAddrRpcService;
import com.elitesland.yst.system.component.param.SysUserComponentPagingParam;
import com.elitesland.yst.system.component.service.SysComponentService;
import com.elitesland.yst.system.manager.PermissionCacheManager;
import com.elitesland.yst.system.model.bo.SysPermissionBO;
import com.elitesland.yst.system.param.SysRoleQueryParam;
import com.elitesland.yst.system.provider.mq.SystemMqBinding;
import com.elitesland.yst.system.service.ISysRolePermissionService;
import com.elitesland.yst.system.service.ISysRoleService;
import com.elitesland.yst.system.service.ISysUserService;
import com.elitesland.yst.system.service.IUserPermissionService;
import com.elitesland.yst.system.service.param.SysUserPagingParam;
import com.elitesland.yst.system.service.vo.SysCurrentUserPermissions;
import com.elitesland.yst.system.service.vo.SysRolePagingVO;
import com.elitesland.yst.system.service.vo.SysUserPagingVO;
import com.elitesland.yst.system.service.vo.component.SysUserComponentPagingVO;
import com.elitesland.yst.system.vo.AntTreeNode;
import com.elitesland.yst.system.vo.SysPermissionVO;
import com.elitesland.yst.system.vo.SysRoleVO;
import com.elitesland.yst.system.vo.SysUserDTO;
import com.elitesland.yst.system.vo.SysUserDetailsVO;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/test"}, produces={"application/json"})
@Api(value="\u63a5\u53e3\u6d4b\u8bd5", tags={"\u6d4b\u8bd5"})
public class SysTestController {
    private static final Logger log = LogManager.getLogger(SysTestController.class);
    @Autowired
    private PermissionCacheManager permissionCacheManager;
    @Autowired
    private IUserPermissionService userPermissionService;
    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    private ISysRoleService sysRoleService;
    @Autowired
    private ISysRolePermissionService sysRolePermissionService;
    @Autowired
    private SysComponentService sysComponentService;
    @DubboReference
    private OrgAddrRpcService orgAddrRpcService;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired(required=false)
    private SystemMqBinding systemMqBinding;

    @GetMapping(value={"/queryPermission"})
    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u5bf9\u5e94\u7684\u6743\u9650\u8d44\u6e90\uff08\u7f13\u5b58\uff09")
    @ApiOperationSupport(order=1)
    public ApiResult<Object> queryPermission(SysPermTypeEnum permType, Long roleId) {
        Map<Long, List<SysPermissionBO>> result = this.permissionCacheManager.getRoleWithPermission(permType);
        if (roleId != null) {
            return ApiResult.ok(result.get(roleId));
        }
        return ApiResult.ok(result);
    }

    @GetMapping(value={"/queryPermissionActions"})
    @ApiOperation(value="\u83b7\u53d6\u6743\u9650\u6309\u94ae\u6240\u9700\u89d2\u8272\uff08\u7f13\u5b58\uff09")
    @ApiOperationSupport(order=1)
    public ApiResult<Object> queryPermissionActions(Long permissionId) {
        List<PermissionActionBO> result = this.permissionCacheManager.getPermissionActions();
        if (permissionId != null && !result.isEmpty()) {
            PermissionActionBO resultOne = result.stream().filter(t -> t.getId().longValue() == permissionId.longValue()).findFirst().orElse(null);
            return ApiResult.ok((Object)resultOne);
        }
        return ApiResult.ok(result);
    }

    @GetMapping(value={"/clearPermission"})
    @ApiOperation(value="\u6e05\u9664\u7f13\u5b58\u4e2d\u7684\u6743\u9650\u8d44\u6e90")
    @ApiOperationSupport(order=2)
    public ApiResult<Object> clearPermission() {
        this.permissionCacheManager.clearPermissionCache();
        return ApiResult.ok();
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f")
    @ApiOperationSupport(order=3)
    @GetMapping(value={"/users/current"})
    public String getCurrentUser() throws JsonProcessingException {
        GeneralUserDetails obj = SecurityUtil.getUser();
        return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)obj);
    }

    @ApiOperation(value="\u7528\u6237\u4fe1\u606f\u83b7\u53d6\uff08\u6a21\u62df\u767b\u9646\uff09")
    @ApiOperationSupport(order=10)
    @GetMapping(value={"/user/get"})
    public String getUserInfo(String username) throws JsonProcessingException {
        SysUserDTO obj = this.sysUserService.getUserByUsername(username);
        return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)obj);
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u7528\u6237\u7684\u83dc\u5355\u6811")
    @ApiOperationSupport(order=11)
    @GetMapping(value={"/users/current/menutrees/{terminalCode}"})
    public ApiResult<List<SysCurrentUserPermissions>> queryMenuTree(@PathVariable String terminalCode) {
        return this.userPermissionService.currentUserPermissionMenuTree1(terminalCode);
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u7528\u6237\u7684\u83dc\u5355\u5217\u8868")
    @ApiOperationSupport(order=11)
    @GetMapping(value={"/users/current/menus/{terminalCode}"})
    public ApiResult<List<SysCurrentUserPermissions>> queryMenuList(@PathVariable String terminalCode) {
        return this.userPermissionService.currentUserPermissionMenuList(terminalCode);
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u7528\u6237\u83dc\u5355\u4e0b\u7684\u64cd\u4f5c\u6e05\u5355")
    @ApiOperationSupport(order=12)
    @GetMapping(value={"/users/current/menus/{menuId}/{terminalCode}"})
    public ApiResult<List<SysCurrentUserPermissions>> queryActionsOfMenu(@PathVariable Long menuId, @PathVariable String terminalCode) {
        return this.userPermissionService.currentUserPermissionActionListOfMenu(menuId, terminalCode);
    }

    @ApiOperation(value="\u7528\u6237\u5217\u8868\u5206\u9875\u67e5\u8be2")
    @ApiOperationSupport(order=21)
    @PostMapping(value={"/users/paging"})
    public ApiResult<PagingVO<SysUserPagingVO>> findPaging(@RequestBody SysUserPagingParam param) {
        return ApiResult.ok((Object)this.sysUserService.findPaging(param));
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u5206\u9875\u6570\u636e-\u653e\u5927\u955c\u7ec4\u4ef6")
    @ApiOperationSupport(order=21)
    @PostMapping(value={"/user/paging"})
    public ApiResult<PagingVO<SysUserComponentPagingVO>> findUserComPaging(@RequestBody SysUserComponentPagingParam param) {
        return ApiResult.ok(this.sysComponentService.findSysUserPagingByParam(param));
    }

    @ApiOperation(value="\u901a\u8fc7ID\u53d6\u5f97\u7528\u6237\u660e\u7ec6\uff08\u65b0\uff09")
    @ApiOperationSupport(order=21)
    @GetMapping(value={"/users/details/{id}"})
    public ApiResult<SysUserDetailsVO> findDetailsById(@PathVariable Long id) {
        return ApiResult.ok((Object)this.sysUserService.findDetailsById(id));
    }

    @ApiOperation(value="\u5e94\u7528\u89d2\u8272\u5206\u9875\u67e5\u8be2")
    @ApiOperationSupport(order=22)
    @PostMapping(value={"/roles/q"})
    public ApiResult<PagingVO<SysRolePagingVO>> sysRolePagingSearch(@RequestBody SysRoleQueryParam param) {
        return ApiResult.ok((Object)this.sysRoleService.sysRolePagingSearch(param));
    }

    @ApiOperation(value="\u83b7\u53d6\u53ef\u5206\u914d\u6743\u9650\u7684\u83dc\u5355\u6811")
    @ApiOperationSupport(order=23)
    @GetMapping(value={"/permissions/menutree/{terminalCode}"})
    public ApiResult<List<AntTreeNode>> getMenuTree(@PathVariable String terminalCode) {
        return this.userPermissionService.currentUserPermissionMenuTree(terminalCode);
    }

    @ApiOperation(value="\u67e5\u8be2\u89d2\u8272\u4e0b\u7684\u5df2\u5173\u8054\u7684\u83dc\u5355")
    @ApiOperationSupport(order=24)
    @GetMapping(value={"/roles/{id}/menuids"})
    public ApiResult<List<String>> listMenuIdsById(@PathVariable Long id) {
        return ApiResult.ok((Object)this.sysRoleService.listMenusById(id));
    }

    @ApiOperation(value="\u67e5\u8be2\u89d2\u8272\u4e0b\u5df2\u5173\u8054\u7684\u52a8\u4f5c")
    @ApiOperationSupport(order=25)
    @GetMapping(value={"/roles/{id}/actionids"})
    public ApiResult<List<String>> listActionIdsById(@PathVariable Long id) {
        return ApiResult.ok((Object)this.sysRoleService.listActionsById(id));
    }

    @ApiOperation(value="\u67e5\u8be2\u89d2\u8272\u4e0b\u7684\u83dc\u5355\u5df2\u7ed1\u5b9a\u7684\u52a8\u4f5c")
    @ApiOperationSupport(order=26)
    @GetMapping(value={"/roles/{id}/menus/{menuId}"})
    public ApiResult<Set<SysPermissionVO>> listActionsByMenuOfRole(@PathVariable Long id, @PathVariable Long menuId) {
        return ApiResult.ok((Object)this.sysRolePermissionService.listActionsByMenuIdOfRole(id, menuId));
    }

    @ApiOperation(value="\u5217\u51fa\u6240\u6709\u89d2\u8272")
    @ApiOperationSupport(order=27)
    @GetMapping(value={"/roles/all"})
    public ApiResult<List<SysRoleVO>> listAll() {
        List roles = this.sysRoleService.listAllByPermission();
        return ApiResult.ok((Object)roles);
    }

    @ApiOperation(value="\u6a21\u7cca\u67e5\u8be2redis keys")
    @ApiOperationSupport(order=30)
    @GetMapping(value={"/reids/keys"})
    public ApiResult<Set<String>> scanRedisKeys(String prefix) {
        String key = prefix + "*";
        Set keys = this.redisUtils.getRedisTemplate().keys((Object)key);
        log.info("\u6570\u91cf\uff1a{}", (Object)keys.size());
        List keys1 = this.redisUtils.scan(key);
        return ApiResult.ok(new HashSet(keys1));
    }

    @ApiOperation(value="\u6d4b\u8bd5redis\u503c\u64cd\u4f5c")
    @ApiOperationSupport(order=31)
    @GetMapping(value={"\u6d4b\u8bd5redis\u503c\u64cd\u4f5c"})
    public ApiResult<String> testRedisValue(String key, String value) {
        if (!StringUtils.hasText((String)key)) {
            return ApiResult.fail((String)"key\u4e3a\u7a7a");
        }
        if (StringUtils.hasText((String)value)) {
            this.redisUtils.set(key, (Object)value);
            return ApiResult.ok((Object)("\u8bbe\u7f6e\u503c\uff1a" + value));
        }
        value = (String)this.redisUtils.get(key);
        return ApiResult.ok((Object)("\u53d6\u5f97\u503c\uff1a" + value));
    }

    @ApiOperation(value="MQ\u53d1\u9001\u6d88\u606f")
    @ApiOperationSupport(order=40)
    @GetMapping(value={"/mq/send"})
    public ApiResult<String> testSendMq() {
        Message message = MessageBuilder.withPayload((Object)"hello").setHeader("un", (Object)"wangs").build();
        this.systemMqBinding.systemOutput().send(message);
        return ApiResult.ok((Object)"success");
    }

    @ApiOperation(value="\u6d4b\u8bd5\u83b7\u53d6\u670d\u52a1\u5668\u4fe1\u606f")
    @ApiOperationSupport(order=50)
    @GetMapping(value={"/server/info"})
    public ApiResult<Map<String, Object>> testGetServerInfo(HttpServletRequest request) {
        HashMap<String, CharSequence> result = new HashMap<String, CharSequence>();
        result.put("\u8bf7\u6c42\u8def\u5f84", request.getRequestURL());
        result.put("header-origin", request.getHeader("Origin"));
        result.put("header-host", request.getHeader("Host"));
        result.put("header-referer", request.getHeader("Referer"));
        result.put("\u89e3\u6790\u5f97\u57df\u540d", HttpServletUtil.obtainDomain((HttpServletRequest)request));
        return ApiResult.ok(result);
    }
}

