/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.rest;

import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.system.param.SysUdcQueryParam;
import com.elitesland.yst.system.service.ISysUdcService;
import com.elitesland.yst.system.vo.SysUdcVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/codes"})
@Api(value="\u7cfb\u7edf\u5206\u7c7b\u7801\u7ef4\u62a4", tags={"\u7cfb\u7edf\u5206\u7c7b\u7801\u7ef4\u62a4"})
public class SysUdcController {
    private static final Logger log = LoggerFactory.getLogger(SysUdcController.class);
    private final ISysUdcService sysUdcService;

    @PostMapping(value={"/q"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5206\u7c7b\u7801")
    public ApiResult<PagingVO<SysUdcVO>> listCodes(@RequestBody SysUdcQueryParam param) {
        PagingVO ret = this.sysUdcService.search(param);
        return ApiResult.ok((Object)ret);
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u67e5\u770b\u5206\u7c7b\u7801\u8be6\u60c5")
    public ApiResult<Object> getById(@PathVariable(value="id") Long id) {
        return ApiResult.ok((Object)this.sysUdcService.findOneById(id));
    }

    @GetMapping(value={"/combo/{domain}/{udc}"})
    @ApiOperation(value="\u83b7\u53d6\u4e0b\u62c9\u5206\u7c7b\u7801")
    public ApiResult<Object> listCombos(@PathVariable(value="domain") String domain, @PathVariable(value="udc") String udc) {
        List combos = this.sysUdcService.listCodeCombos(domain, udc);
        return ApiResult.ok((Object)combos);
    }

    @PostMapping
    @ApiOperation(value="\u521b\u5efa\u5206\u7c7b\u7801")
    public ApiResult<Long> createCode(@RequestBody @Valid SysUdcVO udc) {
        return this.sysUdcService.createCode(udc);
    }

    @PutMapping
    @ApiOperation(value="\u66f4\u65b0\u5206\u7c7b\u7801")
    public ApiResult<Long> updateCode(@RequestBody @Valid SysUdcVO udc) {
        return this.sysUdcService.updateCode(udc);
    }

    @DeleteMapping(value={"/{syscode}"})
    @ApiOperation(value="\u5220\u9664\u9886\u57df\u7801\u4e0b\u6240\u6709\u7684UDC")
    public ApiResult<Boolean> remvoeBySysCode(@PathVariable(value="syscode") String syscode) {
        return this.sysUdcService.removeBySys(syscode);
    }

    @DeleteMapping(value={"/{syscode}/{modcode}"})
    @ApiOperation(value="\u5220\u9664\u9886\u57df\u7801\u4e0b\uff0c \u6a21\u7cca\u5339\u914d\u7684\u7684UDC")
    public ApiResult<Boolean> remvoeBySysCode(@PathVariable(value="syscode") String syscode, @PathVariable(value="modcode") String modcode) {
        return this.sysUdcService.removeByMod(syscode, modcode);
    }

    @DeleteMapping(value={"/{syscode}/{modcode}/{key}"})
    @ApiOperation(value="\u5220\u9664\u9886\u57df\u7801\u4e0b, UDC\u5206\u7c7b\u4e0b\uff0c\u6a21\u7cca\u5339\u914d\u7684UDC\u503c")
    public ApiResult<Boolean> remvoeBySysCode(@PathVariable(value="syscode") String syscode, @PathVariable(value="modcode") String modcode, @PathVariable(value="key") String key) {
        return this.sysUdcService.removeByKey(syscode, modcode, key);
    }

    @DeleteMapping(value={"/idinbatch"})
    @ApiOperation(value="\u6839\u636e\u9009\u62e9\u7684ID\uff0c\u6279\u91cf\u5220\u9664UDC")
    public ApiResult<Boolean> removeByIdInBatch(@RequestBody List<Long> ids) {
        return this.sysUdcService.removeByIdInBatch(ids);
    }

    @ApiOperation(value="\u6e05\u7a7a\u6240\u6709UDC\u7f13\u5b58")
    @DeleteMapping(value={"/cache"})
    public ApiResult<Boolean> clearCache(Boolean all) {
        return this.sysUdcService.clearCache(all);
    }

    @ApiOperation(value="\u6e05\u7a7a\u6240\u6709UDC\u7f13\u5b58")
    @DeleteMapping(value={"/cache_udc"})
    public ApiResult<Boolean> clearCache(String domain, String udcCode, Boolean all) {
        return this.sysUdcService.clearUdcCache(domain, udcCode, all);
    }

    public SysUdcController(ISysUdcService sysUdcService) {
        this.sysUdcService = sysUdcService;
    }
}

