/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.rest;

import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.util.EncryptUtils;
import com.elitesland.yst.core.security.component.PermissionWithRoleCacheService;
import com.elitesland.yst.system.param.SysPasswordUpdate;
import com.elitesland.yst.system.param.SysPhoneUpdate;
import com.elitesland.yst.system.param.SysUserBatchSwitchParam;
import com.elitesland.yst.system.param.SysUserNewParam;
import com.elitesland.yst.system.param.SysUserQueryParam;
import com.elitesland.yst.system.param.SysUserUpdateParam;
import com.elitesland.yst.system.service.ISysUserService;
import com.elitesland.yst.system.service.IUserPermissionService;
import com.elitesland.yst.system.service.param.SysUserPagingParam;
import com.elitesland.yst.system.service.vo.SysCurrentUserPermissions;
import com.elitesland.yst.system.service.vo.SysUserPagingVO;
import com.elitesland.yst.system.util.DigestsUtils;
import com.elitesland.yst.system.util.EncodeUtils;
import com.elitesland.yst.system.vo.SysPermissionWithRoleVO;
import com.elitesland.yst.system.vo.SysUserDTO;
import com.elitesland.yst.system.vo.SysUserDetailsVO;
import com.elitesland.yst.system.vo.SysUserVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/users"})
@Api(value="\u7cfb\u7edf\u7528\u6237\u8d26\u53f7\u7ef4\u62a4", tags={"\u7cfb\u7edf\u7528\u6237\u8d26\u53f7\u7ef4\u62a4"})
public class SysUserController {
    private static final Logger log = LoggerFactory.getLogger(SysUserController.class);
    private final ISysUserService sysUserService;
    private final PermissionWithRoleCacheService permissionWithRoleCacheService;
    private final IUserPermissionService userPermissionService;

    @PostMapping(value={"/q"})
    @ApiOperation(value="\u68c0\u7d22\u7684\u7528\u6237\u8d26\u53f7\u4fe1\u606f")
    @ApiResponses(value={@ApiResponse(code=200, response=SysUserVO.class, message="\u5904\u7406\u6210\u529f")})
    public ApiResult<PagingVO<SysUserVO>> search(@RequestBody SysUserQueryParam param) {
        PagingVO ret = this.sysUserService.search(param);
        return ApiResult.ok((Object)ret);
    }

    @PostMapping(value={"paging"})
    @ApiOperation(value="\u7528\u6237\u8d26\u53f7\u5206\u9875\u67e5\u8be2")
    public ApiResult<PagingVO<SysUserPagingVO>> findPaging(@RequestBody SysUserPagingParam param) {
        return ApiResult.ok((Object)this.sysUserService.findPaging(param));
    }

    @PostMapping
    @ApiOperation(value="\u521b\u5efa\u7528\u6237\u8d26\u53f7")
    public ApiResult<String> create(@RequestBody SysUserNewParam user) {
        Long id = this.sysUserService.create(user, null);
        return ApiResult.ok((Object)id.toString());
    }

    @PutMapping
    @ApiOperation(value="\u66f4\u65b0\u7528\u6237\u4fe1\u606f")
    public ApiResult<Boolean> update(@RequestBody @Validated SysUserUpdateParam user) {
        this.sysUserService.update(user);
        return ApiResult.ok((Object)true);
    }

    @GetMapping(value={"/details/{id}"})
    @ApiOperation(value="\u901a\u8fc7ID\u53d6\u5f97\u7528\u6237\u660e\u7ec6\uff08\u65b0\uff09")
    public ApiResult<SysUserDetailsVO> findDetailsById(@PathVariable Long id) {
        return ApiResult.ok((Object)this.sysUserService.findDetailsById(id));
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u901a\u8fc7ID\u53d6\u5f97\u7528\u6237\u660e\u7ec6\u4fe1\u606f\uff08\u5e9f\u5f03\uff09")
    public ApiResult<SysUserDTO> one(@PathVariable Long id) {
        SysUserDTO user = this.sysUserService.getById(id);
        if (user == null) {
            return ApiResult.fail((ApiCode)ApiCode.NOT_FOUND);
        }
        return ApiResult.ok((Object)user);
    }

    @GetMapping(value={"/current"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f")
    public ApiResult<SysUserDTO> current() {
        SysUserDTO u = this.sysUserService.current();
        if (u == null) {
            return ApiResult.ok(null);
        }
        u.setPassword(null).setPermissions(null);
        return ApiResult.ok((Object)u);
    }

    @GetMapping(value={"/redisUtils"})
    @ApiOperation(value="redisUtils")
    public ApiResult<List<SysPermissionWithRoleVO>> redisUtils() {
        List rolePerms = this.permissionWithRoleCacheService.getPermissionWithRole();
        return ApiResult.ok((Object)rolePerms);
    }

    @GetMapping(value={"/current/menus/{terminalCode}"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u5e94\u7528\u6e05\u5355")
    public ApiResult<List<SysCurrentUserPermissions>> currentMenus(@PathVariable String terminalCode) {
        return this.userPermissionService.currentUserPermissionMenuList(terminalCode);
    }

    @GetMapping(value={"/current/menutrees/{terminalCode}"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u5e94\u7528\u6e05\u5355(\u6811\u7ed3\u6784)")
    public ApiResult<List<SysCurrentUserPermissions>> currentMenuTrees(@RequestParam(required=false, defaultValue="0") Long nodeId, @PathVariable String terminalCode) {
        return this.userPermissionService.currentUserPermissionMenuTree1(terminalCode);
    }

    @GetMapping(value={"/current/menus/{menuId}/{terminalCode}"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\uff0c\u5f53\u524d\u9875\u9762\u7684\u64cd\u4f5c\u6e05\u5355")
    public ApiResult<List<SysCurrentUserPermissions>> currentMenuActions(@PathVariable Long menuId, @PathVariable String terminalCode) {
        return this.userPermissionService.currentUserPermissionActionListOfMenu(menuId, terminalCode);
    }

    @GetMapping(value={"/current/actions"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u64cd\u4f5c\u6e05\u5355")
    public ApiResult<List<SysCurrentUserPermissions>> currentActions() {
        return this.userPermissionService.currentUserPermissionActionList();
    }

    @PutMapping(value={"/reset/pwd/{userId}"})
    @ApiOperation(value="\u91cd\u7f6e\u5bc6\u7801")
    public ApiResult<Object> resetPasswordByUserId(@PathVariable Long userId) {
        this.sysUserService.resetPasswordByUserId(userId);
        return ApiResult.ok();
    }

    @PutMapping(value={"/{id}"})
    @ApiOperation(value="\u5207\u6362\u7528\u6237\u542f\u7528\u72b6\u6001")
    public ApiResult<Boolean> switchUserStatus(@PathVariable Long id) {
        Boolean ret = this.sysUserService.switchUserStatus(id);
        return ApiResult.ok((Object)ret);
    }

    @PutMapping(value={"/switch/batch"})
    @ApiOperation(value="\u6279\u91cf\u5207\u6362\u7528\u6237\u542f\u7528\u72b6\u6001")
    public ApiResult<Object> switchUserStatus(@RequestBody SysUserBatchSwitchParam param) {
        this.sysUserService.batchSwitchUserStatus(param);
        return ApiResult.ok();
    }

    @PutMapping(value={"/changep"})
    @ApiOperation(value="\u4fee\u6539\u7528\u6237\u5bc6\u7801")
    public ApiResult<Object> updatePassword(@RequestBody SysPasswordUpdate update) {
        this.sysUserService.updatePassword(update);
        return ApiResult.ok();
    }

    @PutMapping(value={"/changeNewP"})
    @ApiOperation(value="\u4fee\u6539\u7528\u6237\u5bc6\u7801,\u65e0\u9700\u9a8c\u8bc1\u65e7\u5bc6\u7801")
    public ApiResult<Object> updatePassword2(@RequestBody SysPasswordUpdate update) {
        this.sysUserService.updatePassword2(update);
        return ApiResult.ok();
    }

    @PutMapping(value={"/changePhone"})
    @ApiOperation(value="\u4fee\u6539\u7528\u6237\u5bc6\u7801")
    public ApiResult<Object> updatePhone(@RequestBody SysPhoneUpdate update) {
        return ApiResult.ok((Object)this.sysUserService.updateAccountPhone(update));
    }

    @GetMapping(value={"/decode"})
    @ApiOperation(value="\u524d\u7aef\u5bc6\u7801\u89e3\u5bc6-\u6d4b\u8bd5")
    public ApiResult<?> decode(@RequestParam String rawPassworod) throws UnsupportedEncodingException {
        return ApiResult.ok((Object)EncryptUtils.decodeBase64((String)rawPassworod));
    }

    private String encryptPassword(byte[] salt, String password) {
        byte[] hashPassword = DigestsUtils.sha1(password.getBytes(), salt, 1024);
        return EncodeUtils.encodeHex(hashPassword);
    }

    @PutMapping(value={"updateReole"})
    @ApiOperation(value="\u66f4\u65b0\u7528\u6237\u89d2\u8272\u4fe1\u606f")
    public ApiResult<Boolean> updateReole(@RequestBody @Validated SysUserUpdateParam user) {
        this.sysUserService.updateReole(user);
        return ApiResult.ok((Object)true);
    }

    @PatchMapping(value={"/testUserName/{id}/{userName}"})
    @ApiOperation(value="\u9a8c\u8bc1\u8d26\u53f7\u4e0d\u80fd\u91cd\u590d")
    public ApiResult<Object> testUserName(@PathVariable Long id, @PathVariable String userName) {
        return this.sysUserService.testUserName(id, userName);
    }

    @PatchMapping(value={"/testMobile/{id}/mobile"})
    @ApiOperation(value="\u9a8c\u8bc1\u624b\u673a\u53f7\u91cd\u590d")
    public ApiResult<Object> testMobile(@PathVariable Long id, @PathVariable String mobile) {
        return this.sysUserService.testMobile(id, mobile);
    }

    @PutMapping(value={"/updateusernameandphone"})
    @ApiOperation(value="\u66f4\u65b0\u8d26\u53f7\u548c\u624b\u673a\u597d")
    public ApiResult<Boolean> updateusernameandphone(@RequestBody @Validated SysUserUpdateParam user) {
        this.sysUserService.updateusernameandphone(user);
        return ApiResult.ok((Object)true);
    }

    public SysUserController(ISysUserService sysUserService, PermissionWithRoleCacheService permissionWithRoleCacheService, IUserPermissionService userPermissionService) {
        this.sysUserService = sysUserService;
        this.permissionWithRoleCacheService = permissionWithRoleCacheService;
        this.userPermissionService = userPermissionService;
    }
}

